/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.FlowPanelRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class FlowLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private FlowPanel panel = new /* Unavailable Anonymous Inner Class!! */;
    private String cssClassName;
    private String id;

    public FlowLayoutFormItem() {
        this(new ArrayList());
    }

    public FlowLayoutFormItem(List<FBFormEffect> effects) {
        super(effects);
        this.setSize("190px", "90px");
        this.panel.setSize(this.getWidth(), this.getHeight());
        this.add((Widget)this.panel);
    }

    private void populate(FlowPanel panel) {
        if (this.getHeight() != null) {
            panel.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            panel.setStyleName(this.cssClassName);
        }
        if (this.getWidth() != null) {
            panel.setWidth(this.getWidth());
        }
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        formItemPropertiesMap.put("id", this.id);
        return formItemPropertiesMap;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.panel);
    }

    public FormItemRepresentation getRepresentation() {
        FlowPanelRepresentation rep = (FlowPanelRepresentation)super.getRepresentation((FormItemRepresentation)new FlowPanelRepresentation());
        ArrayList<FormItemRepresentation> items = new ArrayList<FormItemRepresentation>();
        for (FBFormItem item : this.getItems()) {
            items.add(item.getRepresentation());
        }
        rep.setItems(items);
        rep.setId(this.id);
        rep.setCssClassName(this.cssClassName);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof FlowPanelRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "FlowPanelRepresentation"));
        }
        super.populate(rep);
        FlowPanelRepresentation frep = (FlowPanelRepresentation)rep;
        this.cssClassName = frep.getCssClassName();
        this.id = frep.getId();
        super.getItems().clear();
        this.populate(this.panel);
        if (frep.getItems() != null) {
            for (FormItemRepresentation item : frep.getItems()) {
                this.add(LayoutFormItem.createItem((FormItemRepresentation)item));
            }
        }
    }

    public FBFormItem cloneItem() {
        FlowLayoutFormItem clone = (FlowLayoutFormItem)super.cloneItem((FBFormItem)new FlowLayoutFormItem(this.getFormEffects()));
        clone.cssClassName = this.cssClassName;
        clone.id = this.id;
        clone.populate(clone.panel);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        FlowPanel fp = new FlowPanel();
        this.populate(fp);
        super.populateActions(fp.getElement());
        for (FBFormItem item : this.getItems()) {
            fp.add(item.cloneDisplay(data));
        }
        return fp;
    }

    public HasWidgets getPanel() {
        return this.panel;
    }

    public boolean add(FBFormItem item) {
        this.panel.add((Widget)item);
        return super.add(item);
    }

    public void add(PhantomPanel phantom, int x, int y) {
        for (int index = 0; index < this.panel.getWidgetCount(); ++index) {
            Widget item = this.panel.getWidget(index);
            int left = item.getAbsoluteLeft();
            int right = left + item.getOffsetWidth();
            int top = item.getAbsoluteTop();
            int bottom = top + item.getOffsetHeight();
            if (x <= left || x >= right || y <= top || y >= bottom) continue;
            this.panel.insert((Widget)phantom, index);
            break;
        }
    }

    public void replacePhantom(FBFormItem item) {
        PhantomPanel phantom = null;
        for (Widget widget : this.panel) {
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom != null) {
            int index = this.panel.getWidgetIndex(phantom);
            super.insert(index, item);
            this.remove((Widget)phantom);
        } else {
            this.add(item);
        }
    }
}

