/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.HasSourceReference;
import org.jbpm.formapi.client.form.I18NFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.ImageRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.I18NUtils;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.resources.FormBuilderResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class ImageFormItem
extends FBFormItem
implements I18NFormItem,
HasSourceReference {
    private Image image = new Image();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final I18NUtils utils = new I18NUtils();
    private String altText;
    private String url;
    private String id;

    public ImageFormItem() {
        this(new ArrayList());
    }

    public ImageFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.image.setResource(FormBuilderResources.INSTANCE.defaultImage());
        this.add((Widget)this.image);
        this.setWidth("200px");
        this.setHeight("150px");
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("altText", this.altText);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("url", this.url);
        map.put("id", this.id);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.altText = this.extractString(asPropertiesMap.get("altText"));
        Map i18nMap = this.getI18nMap();
        i18nMap.put("default", this.altText);
        this.saveI18nMap(i18nMap);
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.url = this.extractString(asPropertiesMap.get("url"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.image);
    }

    private void populate(Image image) {
        if (this.altText != null) {
            image.setAltText(this.altText);
            image.setTitle(this.altText);
        }
        if (this.getHeight() != null) {
            image.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            image.setWidth(this.getWidth());
        }
        if (this.url != null && !"".equals(this.url)) {
            image.setUrl(this.url);
        }
    }

    public FormItemRepresentation getRepresentation() {
        ImageRepresentation rep = (ImageRepresentation)super.getRepresentation((FormItemRepresentation)new ImageRepresentation());
        rep.setAltText(this.altText);
        rep.setUrl(this.url);
        rep.setId(this.id);
        rep.setI18n(this.getI18nMap());
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        String i18nAltText;
        if (!(rep instanceof ImageRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "ImageRepresentation"));
        }
        super.populate(rep);
        ImageRepresentation irep = (ImageRepresentation)rep;
        this.altText = irep.getAltText();
        this.url = irep.getUrl();
        this.id = irep.getId();
        this.saveI18nMap(irep.getI18n());
        if ((this.altText == null || "".equals(this.altText)) && (i18nAltText = this.getI18n("default")) != null) {
            this.altText = i18nAltText;
        }
        this.populate(this.image);
    }

    public FBFormItem cloneItem() {
        ImageFormItem clone = (ImageFormItem)super.cloneItem((FBFormItem)new ImageFormItem());
        clone.altText = this.altText;
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.id = this.id;
        clone.url = this.url;
        clone.saveI18nMap(this.getI18nMap());
        clone.populate(clone.image);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        String i18nText;
        Image im = new Image();
        this.populate(im);
        String locale = (String)data.get("org.jbpm.formbuilder.server.render.Renderer.BASE_LOCALE");
        if (locale != null && (i18nText = this.getI18n(locale)) != null && !"".equals(i18nText)) {
            im.setAltText(i18nText);
            im.setTitle(i18nText);
        }
        super.populateActions(im.getElement());
        return im;
    }

    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    public void saveI18nMap(Map<String, String> i18nMap) {
        if (i18nMap != null) {
            String defaultI18n = i18nMap.get("default");
            if (defaultI18n != null && !"".equals(defaultI18n)) {
                this.altText = defaultI18n;
            }
            this.utils.saveI18nMap(i18nMap);
        }
    }

    public void setFormat(I18NFormItem.Format format) {
    }

    public I18NFormItem.Format getFormat() {
        return null;
    }

    public void setSourceReference(String sourceReference) {
        this.url = sourceReference;
        this.image.setUrl(this.url);
    }

    public String getSourceReference() {
        return this.url;
    }

    public List<String> getAllowedTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("jpeg");
        retval.add("jpg");
        retval.add("png");
        retval.add("gif");
        retval.add("svg");
        return retval;
    }
}

