/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.FBInplaceEditor;
import org.jbpm.formapi.client.form.I18NFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.LabelRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.I18NUtils;
import org.jbpm.formbuilder.client.form.editors.LabelInplaceEditor;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class LabelFormItem
extends FBFormItem
implements I18NFormItem {
    private final Label label = new Label("Label");
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final I18NUtils utils = new I18NUtils();
    private String id;
    private String cssClassName;

    public LabelFormItem() {
        this(new ArrayList());
    }

    public LabelFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.setWidth("200px");
        this.add((Widget)this.getLabel());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("id", this.id);
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        return formItemPropertiesMap;
    }

    public FBInplaceEditor createInplaceEditor() {
        return new LabelInplaceEditor(this);
    }

    public void saveValues(Map<String, Object> propertiesMap) {
        this.id = this.extractString(propertiesMap.get("id"));
        this.setWidth(this.extractString(propertiesMap.get("width")));
        this.setHeight(this.extractString(propertiesMap.get("height")));
        this.cssClassName = this.extractString(propertiesMap.get("cssClassName"));
        this.populate(this.getLabel());
    }

    private void populate(Label label) {
        if (this.getWidth() != null) {
            label.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            label.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            label.setStyleName(this.cssClassName);
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public void addEffect(FBFormEffect effect) {
        super.addEffect(effect);
        effect.setWidget((Widget)this.label);
    }

    public FormItemRepresentation getRepresentation() {
        LabelRepresentation rep = (LabelRepresentation)super.getRepresentation((FormItemRepresentation)new LabelRepresentation());
        rep.setValue(this.label.getText());
        rep.setCssName(this.cssClassName);
        rep.setId(this.id);
        rep.setI18n(this.getI18nMap());
        rep.setFormat(this.getFormat() == null ? null : this.getFormat().toString());
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof LabelRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "LabelRepresentation"));
        }
        super.populate(rep);
        LabelRepresentation lrep = (LabelRepresentation)rep;
        this.label.setText(lrep.getValue());
        this.cssClassName = lrep.getCssName();
        this.id = lrep.getId();
        if (lrep.getWidth() != null && !"".equals(lrep.getWidth())) {
            this.setWidth(lrep.getWidth());
        }
        if (lrep.getHeight() != null && !"".equals(lrep.getHeight())) {
            this.setHeight(lrep.getHeight());
        }
        this.saveI18nMap(lrep.getI18n());
        if (lrep.getFormat() != null && !"".equals(lrep.getFormat())) {
            this.setFormat(I18NFormItem.Format.valueOf((String)lrep.getFormat()));
        }
        this.populate(this.label);
    }

    public FBFormItem cloneItem() {
        LabelFormItem clone = new LabelFormItem(this.getFormEffects());
        clone.cssClassName = this.cssClassName;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.setWidth(this.getWidth());
        clone.getLabel().setText(this.label.getText());
        clone.populate(clone.label);
        clone.saveI18nMap(this.getI18nMap());
        clone.setFormat(this.getFormat());
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        Label lb = new Label();
        this.populate(lb);
        String value = (String)this.getInputValue(data);
        if (value != null) {
            lb.setText(value);
        } else {
            String i18nText;
            String locale = (String)data.get("org.jbpm.formbuilder.server.render.Renderer.BASE_LOCALE");
            lb.setText(this.label.getText());
            if (locale != null && (i18nText = this.getI18n(locale)) != null && !"".equals(i18nText)) {
                lb.setText(i18nText);
            }
        }
        super.populateActions(lb.getElement());
        return lb;
    }

    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    public void saveI18nMap(Map<String, String> i18nMap) {
        if (i18nMap != null) {
            String defaultI18n = i18nMap.get("default");
            if (defaultI18n != null && !"".equals(defaultI18n)) {
                this.label.setText(defaultI18n);
            }
            this.utils.saveI18nMap(i18nMap);
        }
    }

    public I18NFormItem.Format getFormat() {
        return this.utils.getFormat();
    }

    public void setFormat(I18NFormItem.Format format) {
        this.utils.setFormat(format);
    }
}

