/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import gwtupload.server.UploadAction;
import gwtupload.server.exceptions.UploadActionException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.jbpm.formbuilder.server.ServiceFactory;
import org.jbpm.formbuilder.server.file.FileException;
import org.jbpm.formbuilder.server.file.FileService;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FileUploadServlet
extends UploadAction {
    private static final long serialVersionUID = 560635045151739627L;
    private FileService fileService = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
        this.fileService = ServiceFactory.getInstance().getFileService();
    }

    public String executeAction(HttpServletRequest request, List<FileItem> sessionFiles) throws UploadActionException {
        String packageName = request.getParameter("packageName");
        for (FileItem item : FileUploadServlet.getSessionFileItems((HttpServletRequest)request)) {
            if (item.isFormField()) continue;
            String fileName = item.getName();
            byte[] content = item.get();
            if (packageName == null || "".equals(packageName)) continue;
            try {
                return this.fileService.storeFile(packageName, fileName, content);
            }
            catch (FileException e) {
                request.getSession().getServletContext().log("Couldn't store file", (Throwable)e);
            }
        }
        UploadAction.removeSessionFileItems((HttpServletRequest)request);
        return "file(s) uploaded";
    }
}

