/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formapi.shared.form.FormEncodingException;
import org.jbpm.formapi.shared.form.FormEncodingFactory;
import org.jbpm.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;
import org.jbpm.formbuilder.shared.task.TaskRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class JsonLoadInput {
    private FormRepresentation form;
    private TaskRef task;
    private String profile;
    private String _package;
    private String contextPath;
    private Map<String, Object> formData = new HashMap();

    private JsonLoadInput() {
    }

    public FormRepresentation getForm() {
        return this.form;
    }

    public void setForm(FormRepresentation form) {
        this.form = form;
    }

    public TaskRef getTask() {
        return this.task;
    }

    public void setTask(TaskRef task) {
        this.task = task;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String _package) {
        this._package = _package;
    }

    public Map<String, Object> getFormData() {
        if (this.formData == null) {
            this.formData = new HashMap();
        }
        return this.formData;
    }

    public void setFormData(Map<String, Object> formData) {
        this.formData = formData;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public static JsonLoadInput parse(String innerHTML) throws FormEncodingException {
        JSONValue json = JSONParser.parseStrict((String)innerHTML);
        JsonLoadInput input = null;
        if (json.isObject() != null) {
            JSONValue jsonCtx;
            JSONValue jsonPkg;
            input = new JsonLoadInput();
            JSONObject jsonObj = json.isObject();
            if (jsonObj.get("embedded") != null && jsonObj.get("embedded").isString() != null) {
                input.setProfile(jsonObj.get("embedded").isString().stringValue());
            }
            if ((jsonPkg = jsonObj.get("packageName")) != null && jsonPkg.isString() != null) {
                input.setPackage(jsonPkg.isString().stringValue());
            }
            if ((jsonCtx = jsonObj.get("contextPath")) != null && jsonCtx.isString() != null) {
                input.setContextPath(jsonCtx.isString().stringValue());
            }
            if (jsonObj.get("task") != null && jsonObj.get("task").isObject() != null) {
                input.setTask(JsonLoadInput.toTask((JSONObject)jsonObj.get("task").isObject()));
            }
            if (jsonObj.get("formData") != null && jsonObj.get("formData").isObject() != null) {
                input.setFormData(JsonLoadInput.toFormData((JSONObject)jsonObj.get("formData").isObject()));
            }
            if (jsonObj.get("formjson") != null && jsonObj.get("formjson").isString() != null) {
                input.setForm(JsonLoadInput.toForm((String)jsonObj.get("formjson").isString().stringValue()));
            }
        }
        return input;
    }

    private static Map<String, Object> toFormData(JSONObject json) {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        for (String key : json.keySet()) {
            JSONValue value = json.get(key);
            retval.put(key, JsonLoadInput.asActualValue((JSONValue)value));
        }
        return retval;
    }

    private static Object asActualValue(JSONValue value) {
        if (value.isArray() != null) {
            JSONArray arr = value.isArray();
            ArrayList<Object> retval = new ArrayList<Object>();
            for (int index = 0; index < arr.size(); ++index) {
                JSONValue subValue = arr.get(index);
                retval.add(JsonLoadInput.asActualValue((JSONValue)subValue));
            }
            return retval;
        }
        if (value.isBoolean() != null) {
            return String.valueOf(value.isBoolean().booleanValue());
        }
        if (value.isNull() != null) {
            return null;
        }
        if (value.isNumber() != null) {
            return String.valueOf(value.isNumber().doubleValue());
        }
        if (value.isString() != null) {
            return value.isString().stringValue();
        }
        if (value.isObject() != null) {
            return JsonLoadInput.toFormData((JSONObject)value.isObject());
        }
        return null;
    }

    private static FormRepresentation toForm(String json) throws FormEncodingException {
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        FormRepresentation form = decoder.decode(json);
        return form;
    }

    private static TaskRef toTask(JSONObject json) {
        TaskRef retval = null;
        if (json != null) {
            JSONObject jsonMetaData;
            retval = new TaskRef();
            retval.setInputs(JsonLoadInput.getIOData((JSONArray)json.get("inputs").isArray()));
            retval.setOutputs(JsonLoadInput.getIOData((JSONArray)json.get("outputs").isArray()));
            HashMap<String, String> metaData = new HashMap<String, String>();
            JSONObject jSONObject = jsonMetaData = json.get("metaData") == null ? null : json.get("metaData").isObject();
            if (jsonMetaData != null) {
                for (String key : jsonMetaData.keySet()) {
                    metaData.put(key, jsonMetaData.get(key).isString().stringValue());
                }
            }
            retval.setMetaData(metaData);
            if (json.get("packageName") != null && json.get("packageName").isString() != null) {
                retval.setPackageName(json.get("packageName").isString().stringValue());
            }
            if (json.get("processId") != null && json.get("processId").isString() != null) {
                retval.setProcessId(json.get("processId").isString().stringValue());
            }
            if (json.get("taskId") != null && json.get("taskId").isString() != null) {
                retval.setTaskId(json.get("taskId").isString().stringValue());
            }
        }
        return retval;
    }

    private static List<TaskPropertyRef> getIOData(JSONArray jsonIO) {
        ArrayList<TaskPropertyRef> retval = new ArrayList<TaskPropertyRef>();
        if (jsonIO != null) {
            for (int index = 0; index < jsonIO.size(); ++index) {
                JSONObject jsonIo = jsonIO.get(index).isObject();
                TaskPropertyRef io = new TaskPropertyRef();
                if (jsonIo.get("name") != null && jsonIo.get("name").isString() != null) {
                    io.setName(jsonIo.get("name").isString().stringValue());
                }
                if (jsonIo.get("sourceExpression") != null && jsonIo.get("sourceExpression").isString() != null) {
                    io.setSourceExpresion(jsonIo.get("sourceExpression").isString().stringValue());
                }
                retval.add(io);
            }
        }
        return retval;
    }
}

