/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client;

import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Element;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.menu.FBMenuItem;
import org.jbpm.formapi.client.validation.FBValidationItem;
import org.jbpm.formapi.common.reflect.ReflectionHelper;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formapi.shared.form.FormEncodingException;
import org.jbpm.formapi.shared.form.FormEncodingFactory;
import org.jbpm.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.formapi.shared.form.FormRepresentationEncoder;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.command.BaseCommand;
import org.jbpm.formbuilder.client.menu.items.CustomMenuItem;
import org.jbpm.formbuilder.client.menu.items.ErrorMenuItem;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.options.MainMenuOption;
import org.jbpm.formbuilder.client.validation.OtherValidationsAware;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;
import org.jbpm.formbuilder.shared.task.TaskRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParseHelper {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();

    public String asXml(String formItemName, FormItemRepresentation formItem) throws FormEncodingException {
        StringBuilder builder = new StringBuilder();
        String json = FormEncodingFactory.getEncoder().encode(formItem);
        builder.append("<formItem name=\"").append(formItemName).append("\">");
        builder.append("<content><![CDATA[").append(json).append("]]></content>");
        builder.append("</formItem>");
        return builder.toString();
    }

    public String asXml(String groupName, FBMenuItem item) {
        StringBuilder builder = new StringBuilder();
        builder.append("<menuItem>");
        builder.append("<groupName>").append(groupName).append("</groupName>");
        builder.append("<name>").append(item.getDescription().getText()).append("</name>");
        try {
            String json = FormEncodingFactory.getEncoder().encode(item.buildWidget().getRepresentation());
            String jsonTag = "<clone><![CDATA[" + json + "]]></clone>";
            builder.append(jsonTag);
        }
        catch (FormEncodingException e) {
            builder.append("<clone error=\"true\">Exception:").append(e.getMessage()).append("</clone>");
        }
        for (String key : item.getAllowedEvents()) {
            builder.append("<allowedEvent>").append(key).append("</allowedEvent>");
        }
        for (FBFormEffect effect : item.getFormEffects()) {
            builder.append("<effect className=\"").append(effect.getClass().getName()).append("\" />");
        }
        builder.append("</menuItem>");
        return builder.toString();
    }

    public List<TaskRef> readTasks(String responseText) {
        Document xml = XMLParser.parse((String)responseText);
        ArrayList<TaskRef> retval = null;
        NodeList list = xml.getElementsByTagName("task");
        if (list != null) {
            retval = new ArrayList<TaskRef>(list.getLength());
            for (int index = 0; index < list.getLength(); ++index) {
                Element elem = (Element)list.item(index);
                TaskRef ref = new TaskRef();
                ref.setProcessId(elem.getAttribute("processId"));
                ref.setTaskId(elem.getAttribute("taskName"));
                ref.setInputs(this.extractTaskIO(elem.getElementsByTagName("input")));
                ref.setOutputs(this.extractTaskIO(elem.getElementsByTagName("output")));
                NodeList mdList = elem.getElementsByTagName("metaData");
                if (mdList != null) {
                    HashMap<String, String> metaData = new HashMap<String, String>();
                    for (int i = 0; i < mdList.getLength(); ++i) {
                        Element mdElem = (Element)mdList.item(i);
                        metaData.put(mdElem.getAttribute("key"), mdElem.getAttribute("value"));
                    }
                    ref.setMetaData(metaData);
                }
                retval.add(ref);
            }
        }
        return retval;
    }

    public List<MainMenuOption> readMenuOptions(String responseText) {
        Document xml = XMLParser.parse((String)responseText);
        NodeList menuOptions = xml.getElementsByTagName("menuOptions").item(0).getChildNodes();
        return this.readMenuOptions(menuOptions);
    }

    public List<FormRepresentation> readForms(String responseText) {
        Document xml = XMLParser.parse((String)responseText);
        NodeList list = xml.getElementsByTagName("json");
        ArrayList<FormRepresentation> retval = new ArrayList<FormRepresentation>();
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        if (list != null) {
            for (int index = 0; index < list.getLength(); ++index) {
                Node node = list.item(index);
                String json = this.getText(node);
                try {
                    FormRepresentation form = decoder.decode(json);
                    retval.add(form);
                    continue;
                }
                catch (FormEncodingException e) {
                    FormRepresentation error = new FormRepresentation();
                    error.setName(this.i18n.Error(e.getLocalizedMessage()));
                    retval.add(error);
                }
            }
        }
        return retval;
    }

    public Map<String, List<FBMenuItem>> readMenuMap(String responseText) {
        Document xml = XMLParser.parse((String)responseText);
        HashMap<String, List<FBMenuItem>> menuItems = new HashMap<String, List<FBMenuItem>>();
        NodeList groups = xml.getElementsByTagName("menuGroup");
        for (int index = 0; index < groups.getLength(); ++index) {
            Node groupNode = groups.item(index);
            String groupName = ((Element)groupNode).getAttribute("name");
            NodeList items = ((Element)groupNode).getElementsByTagName("menuItem");
            menuItems.put(groupName, this.readMenuItems(items, groupName));
        }
        return menuItems;
    }

    public String getFormItemId(String responseText) {
        return this.textOfFirstNode(responseText, "formItemId");
    }

    public String getFormId(String responseText) {
        return this.textOfFirstNode(responseText, "formId");
    }

    public String getFileName(String responseText) {
        return this.textOfFirstNode(responseText, "fileName");
    }

    public Map<String, String> readPropertyMap(String responseText) {
        Document xml = XMLParser.parse((String)responseText);
        HashMap<String, String> retval = new HashMap<String, String>();
        NodeList list = xml.getElementsByTagName("property");
        for (int index = 0; index < list.getLength(); ++index) {
            Element propElement = (Element)list.item(index);
            String key = propElement.getAttribute("key");
            String value = propElement.getAttribute("value");
            retval.put(key, value);
        }
        return retval;
    }

    public String asXml(FormRepresentation form, Map<String, Object> inputs) throws FormEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append("<formPreview>");
        FormRepresentationEncoder encoder = FormEncodingFactory.getEncoder();
        String json = encoder.encode(form);
        builder.append("<representation><![CDATA[").append(json).append("]]></representation>");
        if (inputs != null) {
            for (Map.Entry<String, Object> entry : inputs.entrySet()) {
                String key = entry.getKey();
                Object obj = entry.getValue();
                builder.append("<input key=\"").append(key).append("\" value=\"").append(obj).append("\"/>");
            }
        }
        builder.append("</formPreview>");
        return builder.toString();
    }

    public List<FBValidationItem> readValidations(String responseText) throws Exception {
        Document xml = XMLParser.parse((String)responseText);
        NodeList validationList = xml.getElementsByTagName("validation");
        ArrayList<FBValidationItem> retval = new ArrayList<FBValidationItem>();
        for (int index = 0; index < validationList.getLength(); ++index) {
            Element valElement = (Element)validationList.item(index);
            String klass = valElement.getAttribute("className");
            Object obj = ReflectionHelper.newInstance((String)klass);
            if (!(obj instanceof FBValidationItem)) continue;
            FBValidationItem validItem = (FBValidationItem)obj;
            validItem.populatePropertiesMap(this.readValidationMap(valElement.getElementsByTagName("property")));
            retval.add(validItem);
        }
        for (FBValidationItem item : retval) {
            if (!(item instanceof OtherValidationsAware)) continue;
            OtherValidationsAware aware = (OtherValidationsAware)item;
            aware.setExistingValidations(retval);
        }
        return retval;
    }

    private Map<String, HasValue<String>> readValidationMap(NodeList properties) {
        HashMap<String, HasValue<String>> retval = new HashMap<String, HasValue<String>>();
        for (int index = 0; index < properties.getLength(); ++index) {
            Element propElement = (Element)properties.item(index);
            String key = propElement.getAttribute("key");
            String value = propElement.getAttribute("value");
            TextBox text = new TextBox();
            text.setValue((Object)value);
            retval.put(key, (HasValue<String>)text);
        }
        return retval;
    }

    private List<MainMenuOption> readMenuOptions(NodeList menuOptions) {
        ArrayList<MainMenuOption> options = new ArrayList<MainMenuOption>();
        for (int index = 0; index < menuOptions.getLength(); ++index) {
            MainMenuOption option;
            block6: {
                Node menuNode = menuOptions.item(index);
                Element menuElement = (Element)menuNode;
                String name = menuElement.getAttribute("name");
                option = new MainMenuOption();
                option.setHtml(name);
                if (menuElement.hasAttribute("commandClass")) {
                    String className = menuElement.getAttribute("commandClass");
                    try {
                        Object obj = ReflectionHelper.newInstance((String)className);
                        if (obj instanceof BaseCommand) {
                            option.setCommand((BaseCommand)obj);
                            break block6;
                        }
                        option.setHtml(option.getHtml() + "(" + this.i18n.NotOfType(className, "BaseCommand") + ")");
                        option.setEnabled(false);
                    }
                    catch (Exception e) {
                        option.setHtml(option.getHtml() + this.i18n.Error(e.getLocalizedMessage()));
                        option.setEnabled(false);
                    }
                } else {
                    option.setSubMenu(this.readMenuOptions(menuElement.getChildNodes()));
                }
            }
            options.add(option);
        }
        return options;
    }

    private String textOfFirstNode(String responseText, String tagName) {
        Document xml = XMLParser.parse((String)responseText);
        Node node = xml.getElementsByTagName(tagName).item(0);
        return this.getText(node);
    }

    private List<TaskPropertyRef> extractTaskIO(NodeList ioList) {
        ArrayList<TaskPropertyRef> retval = null;
        if (ioList != null) {
            retval = new ArrayList<TaskPropertyRef>(ioList.getLength());
            for (int i = 0; i < ioList.getLength(); ++i) {
                Element inElem = (Element)ioList.item(i);
                TaskPropertyRef prop = new TaskPropertyRef();
                String name = inElem.getAttribute("name");
                prop.setName(name);
                String sourceExpression = inElem.getAttribute("source");
                prop.setSourceExpresion(sourceExpression);
                retval.add(prop);
            }
        }
        return retval;
    }

    private List<FBMenuItem> readMenuItems(NodeList items, String groupName) {
        ArrayList<FBMenuItem> menuItems = new ArrayList<FBMenuItem>();
        for (int index = 0; index < items.getLength(); ++index) {
            Node itemNode = items.item(index);
            String itemClassName = ((Element)itemNode).getAttribute("className");
            try {
                Object obj = ReflectionHelper.newInstance((String)itemClassName);
                FBMenuItem menuItem = null;
                if (obj instanceof CustomMenuItem) {
                    CustomMenuItem customItem = (CustomMenuItem)obj;
                    String optionName = ((Element)itemNode).getAttribute("optionName");
                    customItem.setRepresentation(this.makeRepresentation(itemNode));
                    customItem.setOptionName(optionName);
                    customItem.setGroupName(groupName);
                    menuItem = customItem;
                } else if (obj instanceof FBMenuItem) {
                    menuItem = (FBMenuItem)obj;
                } else {
                    throw new Exception(this.i18n.NotOfType(itemClassName, "FBMenuItem"));
                }
                NodeList effects = ((Element)itemNode).getElementsByTagName("effect");
                for (FBFormEffect effect : this.readItemEffects(effects)) {
                    menuItem.addEffect(effect);
                }
                NodeList allowedEvents = ((Element)itemNode).getElementsByTagName("allowedEvent");
                for (String allowedEventName : this.readAllowedEvents(allowedEvents)) {
                    menuItem.addAllowedEvent(allowedEventName);
                }
                menuItems.add(menuItem);
                continue;
            }
            catch (Exception e) {
                menuItems.add((FBMenuItem)new ErrorMenuItem(e.getMessage()));
            }
        }
        return menuItems;
    }

    private List<String> readAllowedEvents(NodeList allowedEvents) {
        ArrayList<String> retval = new ArrayList<String>();
        for (int index = 0; index < allowedEvents.getLength(); ++index) {
            Node node = allowedEvents.item(index);
            retval.add(this.getText(node));
        }
        return retval;
    }

    private FormItemRepresentation makeRepresentation(Node itemNode) throws FormEncodingException {
        NodeList list = ((Element)itemNode).getElementsByTagName("itemJson");
        FormItemRepresentation rep = null;
        if (list.getLength() > 0) {
            Node node = list.item(0);
            String json = this.getText(node);
            FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
            rep = decoder.decodeItem(json);
        }
        return rep;
    }

    private String getText(Node node) {
        NodeList list = node.getChildNodes();
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < list.getLength(); ++index) {
            builder.append(list.item(index).getNodeValue());
        }
        return builder.toString();
    }

    private List<FBFormEffect> readItemEffects(NodeList effects) throws Exception {
        ArrayList<FBFormEffect> itemEffects = new ArrayList<FBFormEffect>();
        for (int i = 0; i < effects.getLength(); ++i) {
            Node effectNode = effects.item(i);
            String effectClassName = ((Element)effectNode).getAttribute("className");
            Object efobj = ReflectionHelper.newInstance((String)effectClassName);
            if (!(efobj instanceof FBFormEffect)) {
                throw new Exception(this.i18n.NotOfType(effectClassName, "FBFormEffect"));
            }
            itemEffects.add((FBFormEffect)efobj);
        }
        return itemEffects;
    }

    public List<String> readRoles(String response) {
        String[] rolesArray = response.split(",");
        ArrayList<String> retval = new ArrayList<String>(rolesArray.length);
        for (String role : rolesArray) {
            retval.add(role);
        }
        return retval;
    }

    public List<String> readFiles(String responseText) {
        Document xml = XMLParser.parse((String)responseText);
        NodeList list = xml.getElementsByTagName("file");
        ArrayList<String> retval = new ArrayList<String>();
        if (list != null) {
            for (int index = 0; index < list.getLength(); ++index) {
                Node node = list.item(index);
                String url = this.getText(node);
                retval.add(url);
            }
        }
        return retval;
    }
}

