/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect.view;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formapi.common.reflect.ReflectionHelper;
import org.jbpm.formapi.shared.api.FBScript;
import org.jbpm.formapi.shared.api.FBScriptHelper;
import org.jbpm.formapi.shared.api.RepresentationFactory;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.effect.EventHandlingFormEffect;
import org.jbpm.formbuilder.client.effect.scripthandlers.PlainTextScriptHelper;
import org.jbpm.formbuilder.client.effect.view.ScriptHelperListPanel;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventHandlingEffectView
extends PopupPanel {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final EventHandlingFormEffect effect;
    private Map<String, FBScript> eventActions = new HashMap();
    private final VerticalPanel mainPanel = new VerticalPanel();
    private final ListBox eventSelectionCombo = new ListBox();
    private final ListBox helperSelectionCombo = new ListBox();
    private final Button addHelperButton = new Button("Add");

    public EventHandlingEffectView(EventHandlingFormEffect formEffect) {
        this.effect = formEffect;
        this.populateEventSelectionCombo();
        this.populateScriptHelpers();
        this.mainPanel.add((Widget)this.createEventPanel());
        this.mainPanel.add((Widget)new Label(this.i18n.LoadingLabel()));
        this.mainPanel.add((Widget)this.createButtonsPanel());
        this.startScriptPanel();
        this.add((Widget)this.mainPanel);
    }

    private void startScriptPanel() {
        String initialEventName = this.eventSelectionCombo.getValue(0);
        FBScript initialScript = (FBScript)this.eventActions.get(initialEventName);
        this.populateScriptHelperView(initialScript);
    }

    private HorizontalPanel createButtonsPanel() {
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        buttonsPanel.add((Widget)this.createSaveContinueButton());
        buttonsPanel.add((Widget)this.createConfirmButton());
        buttonsPanel.add((Widget)this.createCancelButton());
        return buttonsPanel;
    }

    private Button createCancelButton() {
        Button cancelButton = new Button(this.i18n.CancelButton(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return cancelButton;
    }

    private Button createConfirmButton() {
        Button confirmButton = new Button(this.i18n.ConfirmButton(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return confirmButton;
    }

    private Button createSaveContinueButton() {
        Button saveContinueButton = new Button(this.i18n.SaveChangesButton(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return saveContinueButton;
    }

    private FBScript toScript(List<FBScriptHelper> helpers) {
        FBScript script = new FBScript();
        if (helpers != null && !helpers.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (FBScriptHelper helper : helpers) {
                sb.append(helper.asScriptContent());
            }
            script.setContent(sb.toString());
            script.setHelpers(helpers);
        }
        script.setType("text/javascript");
        return script;
    }

    private Grid createEventPanel() {
        Grid eventPanel = new Grid(3, 3);
        eventPanel.setWidget(0, 0, (Widget)new Label("Event:"));
        eventPanel.setWidget(0, 1, (Widget)this.eventSelectionCombo);
        eventPanel.setWidget(1, 0, (Widget)new Label("Editor:"));
        eventPanel.setWidget(1, 1, (Widget)this.helperSelectionCombo);
        eventPanel.setWidget(1, 2, (Widget)this.addHelperButton);
        eventPanel.setWidget(2, 0, (Widget)new Label("Type:"));
        eventPanel.setWidget(2, 1, (Widget)new Label("text/javascript"));
        return eventPanel;
    }

    private void populateScriptHelpers() {
        String classesString = RepresentationFactory.getItemClassName((String)"form.builder.scriptHelpers");
        HashMap<String, String> helpersAvailable = new HashMap<String, String>();
        if (classesString != null) {
            String[] classesNames;
            for (String className : classesNames = classesString.split(",")) {
                try {
                    Object obj = ReflectionHelper.newInstance((String)className);
                    if (!(obj instanceof FBScriptHelper)) continue;
                    FBScriptHelper helper = (FBScriptHelper)obj;
                    helpersAvailable.put(helper.getName(), className);
                }
                catch (Exception e) {
                    this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, "Problem loading script helper " + className, (Throwable)e));
                }
            }
        }
        for (Map.Entry entry : helpersAvailable.entrySet()) {
            this.helperSelectionCombo.addItem((String)entry.getKey());
        }
        this.addHelperButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        for (Map.Entry entry : this.eventActions.entrySet()) {
            FBScript script = (FBScript)entry.getValue();
            List helpers = script == null ? new ArrayList() : script.getHelpers();
            String key = (String)entry.getKey();
            FBScript fbScript = (FBScript)this.eventActions.get(key);
            if (fbScript == null) {
                fbScript = new FBScript();
                this.eventActions.put(key, fbScript);
            }
            fbScript.setHelpers(helpers);
        }
    }

    private void populateEventSelectionCombo() {
        Map actions;
        List possibleEvents = this.effect.getPossibleEvents();
        if (possibleEvents != null) {
            for (String eventName : possibleEvents) {
                this.eventSelectionCombo.addItem(eventName);
            }
        }
        if ((actions = this.effect.getItemActions()) != null) {
            this.eventActions.putAll(actions);
        }
        this.eventSelectionCombo.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ScriptHelperListPanel.ScriptOrderHandler newScriptOrderHandler(FBScript script) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void populateScriptHelperView(FBScript script) {
        List helpers = this.getHelpersForEvent(script);
        ScriptHelperListPanel editorPanel = new ScriptHelperListPanel();
        for (FBScriptHelper helper : helpers) {
            editorPanel.addScriptHelper(helper, this.newScriptOrderHandler(script));
        }
        this.mainPanel.remove(1);
        this.mainPanel.insert((Widget)editorPanel, 1);
    }

    private List<FBScriptHelper> getHelpersForEvent(FBScript script) {
        ArrayList<PlainTextScriptHelper> helpers = null;
        if (script != null) {
            helpers = script.getHelpers();
        }
        if (helpers == null) {
            helpers = new ArrayList<PlainTextScriptHelper>();
            PlainTextScriptHelper helper = new PlainTextScriptHelper();
            helpers.add(helper);
            helper.setScript(script);
            script.setHelpers(helpers);
        }
        return helpers;
    }

    static /* synthetic */ ListBox access$000(EventHandlingEffectView x0) {
        return x0.eventSelectionCombo;
    }

    static /* synthetic */ Map access$100(EventHandlingEffectView x0) {
        return x0.eventActions;
    }

    static /* synthetic */ FBScript access$200(EventHandlingEffectView x0, List x1) {
        return x0.toScript(x1);
    }

    static /* synthetic */ EventHandlingFormEffect access$300(EventHandlingEffectView x0) {
        return x0.effect;
    }

    static /* synthetic */ ListBox access$400(EventHandlingEffectView x0) {
        return x0.helperSelectionCombo;
    }

    static /* synthetic */ List access$500(EventHandlingEffectView x0, FBScript x1) {
        return x0.getHelpersForEvent(x1);
    }

    static /* synthetic */ ScriptHelperListPanel.ScriptOrderHandler access$600(EventHandlingEffectView x0, FBScript x1) {
        return x0.newScriptOrderHandler(x1);
    }

    static /* synthetic */ VerticalPanel access$700(EventHandlingEffectView x0) {
        return x0.mainPanel;
    }

    static /* synthetic */ EventBus access$800(EventHandlingEffectView x0) {
        return x0.bus;
    }

    static /* synthetic */ void access$900(EventHandlingEffectView x0, FBScript x1) {
        x0.populateScriptHelperView(x1);
    }
}

