/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect.view;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.shared.api.Data;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.bus.UndoableEvent;
import org.jbpm.formbuilder.client.bus.UndoableHandler;
import org.jbpm.formbuilder.client.effect.IoBindingEffect;
import org.jbpm.formbuilder.client.effect.view.ExternalDataSourcePanel;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoBindingEffectView
extends PopupPanel {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final ListBox inputList;
    private final ListBox outputList;
    private final CheckBox externalDataCheckbox;
    private final ExternalDataSourcePanel externalDataPanel;
    private final IoBindingEffect effect;

    public IoBindingEffectView(IoBindingEffect ioBindingEffect) {
        this.effect = ioBindingEffect;
        HTML title = new HTML("<strong>" + this.i18n.SelectIoConfig() + "</strong>");
        title.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.inputList = this.createVisualList((Data)this.effect.getItem().getInput(), this.effect.getIoRef().getInputs());
        this.outputList = this.createVisualList((Data)this.effect.getItem().getOutput(), this.effect.getIoRef().getOutputs());
        this.externalDataCheckbox = new CheckBox();
        this.externalDataPanel = new ExternalDataSourcePanel();
        Button applyButton = new Button(this.i18n.ConfirmButton());
        applyButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button cancelButton = new Button(this.i18n.CancelButton());
        cancelButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        FlexTable table = new FlexTable();
        table.setWidget(0, 0, (Widget)new Label(this.i18n.LabelInput()));
        table.setWidget(0, 1, (Widget)this.inputList);
        table.setWidget(1, 0, (Widget)new Label(this.i18n.LabelOutput()));
        table.setWidget(1, 1, (Widget)this.outputList);
        table.setWidget(2, 0, (Widget)this.externalDataCheckbox);
        table.setWidget(2, 1, (Widget)this.createExternalDataPanel());
        table.setWidget(3, 0, (Widget)applyButton);
        table.setWidget(3, 1, (Widget)cancelButton);
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.add((Widget)title);
        vPanel.add((Widget)table);
        this.setWidget((Widget)vPanel);
    }

    private void onApplyBinding() {
        HashMap<String, Object> dataSnapshot = new HashMap<String, Object>();
        String selectedInput = this.inputList.getValue(this.inputList.getSelectedIndex());
        if (selectedInput != null && !"".equals(selectedInput)) {
            dataSnapshot.put("newInput", this.effect.getIoRef().getInput(selectedInput));
        } else {
            dataSnapshot.put("newInput", null);
        }
        dataSnapshot.put("oldInput", this.effect.getInput());
        String selectedOutput = this.outputList.getValue(this.outputList.getSelectedIndex());
        if (selectedOutput != null && !"".equals(selectedOutput)) {
            dataSnapshot.put("newOutput", this.effect.getIoRef().getOutput(selectedOutput));
        } else {
            dataSnapshot.put("newOutput", null);
        }
        dataSnapshot.put("oldOutput", this.effect.getOutput());
        dataSnapshot.put("newExtData", this.externalDataPanel.getData());
        dataSnapshot.put("oldExtData", this.effect.getExtData());
        this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, (UndoableHandler)new /* Unavailable Anonymous Inner Class!! */));
        this.hide();
    }

    private ListBox createVisualList(Data ioData, List<TaskPropertyRef> ioList) {
        ListBox inputList = new ListBox();
        String selectedInputName = ioData == null ? null : ioData.getName();
        inputList.addItem("", "");
        for (TaskPropertyRef io : ioList) {
            inputList.addItem(io.getName() + " (" + io.getSourceExpresion() + ")", io.getName());
            if (selectedInputName == null || !io.getName().equals(selectedInputName)) continue;
            inputList.setSelectedIndex(inputList.getItemCount() - 1);
        }
        return inputList;
    }

    private VerticalPanel createExternalDataPanel() {
        VerticalPanel panel = new VerticalPanel();
        Label message = new Label("Obtain input from external source");
        panel.add((Widget)message);
        this.externalDataCheckbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return panel;
    }

    static /* synthetic */ void access$000(IoBindingEffectView x0) {
        x0.onApplyBinding();
    }

    static /* synthetic */ IoBindingEffect access$100(IoBindingEffectView x0) {
        return x0.effect;
    }

    static /* synthetic */ ExternalDataSourcePanel access$200(IoBindingEffectView x0) {
        return x0.externalDataPanel;
    }
}

