/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.FormElement;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.form.FBCompositeItem;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.client.validation.FBValidationItem;
import org.jbpm.formapi.common.handler.ControlKeyHandler;
import org.jbpm.formapi.common.handler.EventHelper;
import org.jbpm.formapi.common.handler.RightClickHandler;
import org.jbpm.formapi.shared.api.FBScript;
import org.jbpm.formapi.shared.api.FBValidation;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formapi.shared.api.InputData;
import org.jbpm.formapi.shared.api.OutputData;
import org.jbpm.formbuilder.client.bus.ui.FormItemAddedEvent;
import org.jbpm.formbuilder.client.bus.ui.FormItemRemovedEvent;
import org.jbpm.formbuilder.client.menu.FormDataPopupPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FBForm
extends FlowPanel
implements FBCompositeItem {
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private String name;
    private String taskId;
    private String processId;
    private String method;
    private String enctype;
    private String action;
    private Map<String, InputData> inputs;
    private Map<String, OutputData> outputs;
    private List<FBScript> onLoadScripts = new ArrayList();
    private List<FBScript> onSubmitScripts = new ArrayList();
    private List<FBFormItem> formItems = new ArrayList();
    private List<FBValidationItem> validationItems = new ArrayList();
    private final FormDataPopupPanel popup = new FormDataPopupPanel();
    private boolean saved = false;
    private long lastModified = 0L;

    public FBForm() {
        EventHelper.addRightClickHandler((Widget)this, (RightClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventHelper.addKeyboardPasteHandler((Widget)this, (ControlKeyHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onBrowserEvent(Event event) {
        EventHelper.onBrowserEvent((Widget)this, (Event)event);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.popup.setName(name);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
        this.popup.setTaskId(taskId);
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
        this.popup.setProcessId(processId);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
        this.popup.setAction(action);
    }

    public String getEnctype() {
        return this.enctype;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
        this.popup.setEnctype(enctype);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
        this.popup.setMethod(method);
    }

    public List<FBFormItem> getItems() {
        return this.formItems;
    }

    public void setItems(List<FBFormItem> items) {
        this.formItems = items;
    }

    public List<FBValidationItem> getValidationItems() {
        return this.validationItems;
    }

    public void setValidationItems(List<FBValidationItem> validationItems) {
        this.validationItems = validationItems;
    }

    public boolean remove(Widget w) {
        if (w instanceof FBFormItem) {
            FBFormItem item = (FBFormItem)w;
            this.formItems.remove(item);
        }
        return super.remove(w);
    }

    public void add(Widget w) {
        if (w instanceof FBFormItem) {
            FBFormItem formItem = (FBFormItem)w;
            int index = this.getItemPosition(formItem);
            if (index == this.getWidgetCount()) {
                this.formItems.add(formItem);
                super.add(w);
            } else {
                this.insert(w, index);
            }
        } else {
            super.add(w);
        }
    }

    public void add(PhantomPanel phantom, int x, int y) {
        for (int index = 0; index < this.getWidgetCount(); ++index) {
            Widget item = this.getWidget(index);
            int left = item.getAbsoluteLeft();
            int right = left + item.getOffsetWidth();
            int top = item.getAbsoluteTop();
            int bottom = top + item.getOffsetHeight();
            if (x > left && x < right && y > top && y < bottom) {
                this.insert((Widget)phantom, index);
                break;
            }
            if (x > right && y > top && y < bottom && index < this.getWidgetCount() - 1) {
                this.insert((Widget)phantom, index + 1);
                break;
            }
            if (index != this.getWidgetCount() - 1) continue;
            this.add((Widget)phantom);
            break;
        }
    }

    public void insert(Widget widget, int beforeIndex) {
        if (widget instanceof FBFormItem) {
            ArrayList posteriorItems = new ArrayList(this.formItems.subList(beforeIndex, this.formItems.size()));
            this.formItems.removeAll(posteriorItems);
            this.formItems.add((FBFormItem)widget);
            this.formItems.addAll(posteriorItems);
        }
        super.insert(widget, beforeIndex);
    }

    protected int getItemPosition(FBFormItem newItem) {
        int index = this.getWidgetCount();
        if (index == 0) {
            return index;
        }
        if (this.formItems.size() == 0) {
            return 0;
        }
        ListIterator it = this.formItems.listIterator(this.formItems.size() - 1);
        while (it.hasPrevious() && index > 0) {
            boolean aboveItem;
            FBFormItem item = (FBFormItem)it.previous();
            boolean leftOfItem = item.getAbsoluteLeft() > newItem.getDesiredX() && newItem.getDesiredX() > 0;
            boolean bl = aboveItem = item.getAbsoluteTop() > newItem.getDesiredY() && newItem.getDesiredY() > 0;
            if (!aboveItem && !leftOfItem) continue;
            --index;
        }
        return index;
    }

    public void addValidation(FBValidationItem item) {
        this.validationItems.add(item);
    }

    public void onFormLoad() {
    }

    public void onFormSubmit() {
    }

    public void setInputs(Map<String, InputData> inputs) {
        this.inputs = inputs;
    }

    public Map<String, InputData> getInputs() {
        return this.inputs;
    }

    public void setOutputs(Map<String, OutputData> outputs) {
        this.outputs = outputs;
    }

    public Map<String, OutputData> getOutputs() {
        return this.outputs;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
        this.lastModified = System.currentTimeMillis();
    }

    public FormRepresentation createRepresentation() {
        FormRepresentation rep = new FormRepresentation();
        rep.setName(this.name);
        rep.setTaskId(this.taskId);
        rep.setProcessName(this.processId);
        rep.setAction(this.action);
        rep.setMethod(this.method);
        rep.setEnctype(this.enctype);
        for (FBFormItem item : this.formItems) {
            rep.addFormItem(item.getRepresentation());
        }
        for (FBFormItem item : this.validationItems) {
            rep.addFormValidation(item.createValidation());
        }
        rep.setInputs(this.inputs);
        rep.setOutputs(this.outputs);
        rep.setSaved(this.saved);
        rep.setLastModified(this.lastModified);
        rep.setOnLoadScripts(this.onLoadScripts);
        rep.setOnSubmitScripts(this.onSubmitScripts);
        return rep;
    }

    public void populate(FormRepresentation rep) throws FormBuilderException {
        this.setName(rep.getName());
        this.setTaskId(rep.getTaskId());
        this.setProcessId(rep.getProcessName());
        this.setAction(rep.getAction());
        this.setMethod(rep.getMethod());
        this.setEnctype(rep.getEnctype());
        for (FBFormItem item : new ArrayList(this.formItems)) {
            this.remove((Widget)item);
            this.bus.fireEvent((GwtEvent)new FormItemRemovedEvent(item));
        }
        for (FormItemRepresentation itemRep : rep.getFormItems()) {
            FBFormItem item = FBFormItem.createItem((FormItemRepresentation)itemRep);
            item.populate(itemRep);
            this.add((Widget)item);
            this.ensureMinimumSize(item);
            this.bus.fireEvent((GwtEvent)new FormItemAddedEvent(item, (Widget)this));
        }
        for (FBValidation validationRep : rep.getFormValidations()) {
            FBValidationItem validation = FBValidationItem.createValidation((FBValidation)validationRep);
            this.addValidation(validation);
        }
        this.setInputs(rep.getInputs());
        this.setOutputs(rep.getOutputs());
        this.saved = rep.isSaved();
        this.lastModified = rep.getLastModified();
        this.onLoadScripts.clear();
        if (rep.getOnLoadScripts() != null) {
            for (FBScript onLoad : rep.getOnLoadScripts()) {
                this.onLoadScripts.add(onLoad);
            }
        }
        this.onSubmitScripts.clear();
        if (rep.getOnSubmitScripts() != null) {
            for (FBScript onSubmit : rep.getOnSubmitScripts()) {
                this.onSubmitScripts.add(onSubmit);
            }
        }
    }

    protected void ensureMinimumSize(FBFormItem item) {
        if (item.getHeight() != null && !"".equals(item.getHeight()) && item.getHeight().endsWith("px")) {
            int actualHeight = item.getWidget().getOffsetHeight();
            int settedHeight = Integer.valueOf(item.getHeight().replace("px", ""));
            if (actualHeight > 0 && settedHeight < actualHeight) {
                item.setHeight("" + actualHeight + "px");
            }
        }
        if (item.getWidth() != null && !"".equals(item.getWidth()) && item.getWidth().endsWith("px")) {
            int actualWidth = item.getWidget().getOffsetWidth();
            int settedWidth = Integer.valueOf(item.getWidth().replace("px", ""));
            if (actualWidth > 0 && settedWidth < actualWidth) {
                item.setWidth("" + actualWidth + "px");
            }
        }
    }

    public void replacePhantom(FBFormItem item) {
        PhantomPanel phantom = null;
        for (Widget widget : this) {
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom != null) {
            int index = this.getWidgetIndex(phantom);
            this.remove(phantom);
            this.insert((Widget)item, index);
        } else {
            this.add((Widget)item);
        }
    }

    public FormPanel asFormPanel(Map<String, Object> data) {
        FormPanel panel = new FormPanel();
        data.put("org.jbpm.formbuilder.FormBuilder.FORM_PANEL", panel);
        panel.setAction(this.action);
        panel.setEncoding(this.enctype);
        panel.setMethod(this.method);
        FlowPanel flow = new FlowPanel();
        FormElement el = FormElement.as((Element)panel.getElement());
        el.setName(this.name);
        flow.add((Widget)new HTML("<!-- process name: " + this.getProcessId() + ", task name: " + this.getTaskId() + " -->"));
        for (FBFormItem item : this.getItems()) {
            flow.add(item.cloneDisplay(data));
        }
        panel.addSubmitHandler((FormPanel.SubmitHandler)new /* Unavailable Anonymous Inner Class!! */);
        panel.addSubmitCompleteHandler((FormPanel.SubmitCompleteHandler)new /* Unavailable Anonymous Inner Class!! */);
        panel.setWidget((Widget)flow);
        return panel;
    }

    static /* synthetic */ FormDataPopupPanel access$000(FBForm x0) {
        return x0.popup;
    }
}

