/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.OptionsFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.ComboBoxRepresentation;
import org.jbpm.formapi.shared.api.items.OptionRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class ComboBoxFormItem
extends OptionsFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private ListBox listBox = new ListBox();
    Map<String, String> items = new HashMap();
    private Boolean multiple = null;
    private Integer visibleItems = null;
    private String title;
    private String name;
    private String id;

    public ComboBoxFormItem() {
        this(new ArrayList());
    }

    public ComboBoxFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.listBox);
        this.setWidth("50px");
        this.setHeight("21px");
        this.listBox.setSize(this.getWidth(), this.getHeight());
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.multiple = this.extractBoolean(asPropertiesMap.get("multipleSelect"));
        this.visibleItems = this.extractInt(asPropertiesMap.get("verticalSize"));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.listBox);
    }

    private void populate(ListBox listBox) {
        if (this.multiple != null) {
            this.listBox.setMultipleSelect(this.multiple.booleanValue());
        }
        if (this.visibleItems != null && this.visibleItems > 0) {
            this.listBox.setVisibleItemCount(this.visibleItems.intValue());
        }
        if (this.title != null) {
            this.listBox.setTitle(this.title);
        }
        if (this.getWidth() != null) {
            this.listBox.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            this.listBox.setHeight(this.getHeight());
        }
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> itemPropertiesMap = new HashMap<String, Object>();
        itemPropertiesMap.put("multipleSelect", this.multiple);
        itemPropertiesMap.put("verticalSize", this.visibleItems);
        itemPropertiesMap.put("title", this.title);
        itemPropertiesMap.put("width", this.getWidth());
        itemPropertiesMap.put("height", this.getHeight());
        itemPropertiesMap.put("name", this.name);
        itemPropertiesMap.put("id", this.id);
        return itemPropertiesMap;
    }

    public void addItem(String label, String value) {
        if (value == null || "".equals(value)) {
            this.listBox.addItem(label);
            this.items.put(label, label);
        } else {
            this.listBox.addItem(label, value);
            this.items.put(label, value);
        }
    }

    public void deleteItem(String label) {
        if (label != null) {
            this.items.remove(label);
            int size = 0;
            block0: do {
                size = this.listBox.getItemCount();
                for (int index = 0; index < this.listBox.getItemCount(); ++index) {
                    if (!this.listBox.getItemText(index).equals(label)) continue;
                    this.listBox.removeItem(index);
                    continue block0;
                }
            } while (size != this.listBox.getItemCount());
        }
    }

    public FormItemRepresentation getRepresentation() {
        ComboBoxRepresentation rep = (ComboBoxRepresentation)super.getRepresentation((FormItemRepresentation)new ComboBoxRepresentation());
        ArrayList<OptionRepresentation> elements = new ArrayList<OptionRepresentation>();
        for (String label : this.items.keySet()) {
            OptionRepresentation opt = new OptionRepresentation();
            opt.setLabel(label);
            opt.setValue((String)this.items.get(label));
            elements.add(opt);
        }
        rep.setElements(elements);
        rep.setName(this.name);
        rep.setId(this.id);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof ComboBoxRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "TextFieldRepresentation"));
        }
        super.populate(rep);
        ComboBoxRepresentation crep = (ComboBoxRepresentation)rep;
        List options = crep.getElements();
        this.items.clear();
        if (options != null) {
            for (OptionRepresentation option : options) {
                this.items.put(option.getLabel(), option.getValue());
                this.listBox.addItem(option.getLabel(), option.getValue());
            }
        }
        this.listBox.clear();
        this.addItems(this.items, this.listBox);
        this.name = crep.getName();
        this.id = crep.getId();
        this.populate(this.listBox);
    }

    public void addEffect(FBFormEffect effect) {
        super.addEffect(effect);
        effect.setWidget((Widget)this.listBox);
    }

    public Map<String, String> getItems() {
        HashMap<String, String> items = new HashMap<String, String>();
        for (int index = 0; index < this.listBox.getItemCount(); ++index) {
            items.put(this.listBox.getItemText(index), this.listBox.getValue(index));
        }
        return items;
    }

    public void addItems(Map<String, String> items, ListBox listBox) {
        for (Map.Entry<String, String> entry : items.entrySet()) {
            listBox.addItem(entry.getKey(), entry.getValue());
        }
    }

    public FBFormItem cloneItem() {
        ComboBoxFormItem clone = new ComboBoxFormItem(this.getFormEffects());
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.multiple = this.multiple;
        clone.name = this.name;
        clone.title = this.title;
        clone.visibleItems = this.visibleItems;
        clone.setWidth(this.getWidth());
        clone.populate(clone.listBox);
        clone.addItems(this.getItems(), clone.listBox);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        String inputName;
        ListBox lb = new ListBox();
        this.populate(lb);
        this.addItems(this.getItems(), lb);
        Object input = this.getInputValue(data);
        String string = inputName = this.getInput() == null ? null : this.getInput().getName();
        if (input != null && inputName != null) {
            if (input.getClass().isArray()) {
                Object[] arr;
                for (Object obj : arr = (Object[])input) {
                    lb.addItem(obj.toString(), obj.toString());
                }
            } else if (input instanceof Collection) {
                Collection col = (Collection)input;
                for (Object obj : col) {
                    lb.addItem(obj.toString(), obj.toString());
                }
            } else if (input instanceof Map) {
                Map map = (Map)input;
                for (Map.Entry entry : map.entrySet()) {
                    lb.addItem(entry.getKey().toString(), entry.getValue().toString());
                }
            } else {
                String value = input.toString();
                for (int index = 0; index < lb.getItemCount(); ++index) {
                    if (value == null || !value.equals(lb.getValue(index))) continue;
                    lb.setSelectedIndex(index);
                    break;
                }
            }
        }
        super.populateActions(lb.getElement());
        return lb;
    }
}

