/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.media.client.Video;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.HasSourceReference;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.VideoRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class VideoFormItem
extends FBFormItem
implements HasSourceReference {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final Video video = Video.createIfSupported();
    private final Label notSupported = new Label(this.i18n.VideoNotSupported());
    private String cssClassName;
    private String id;
    private String dataType;
    private String videoUrl;

    public VideoFormItem() {
        this(new ArrayList());
    }

    public VideoFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        if (this.video == null) {
            this.add((Widget)this.notSupported);
        } else {
            this.add((Widget)this.video);
        }
        this.video.setWidth("300px");
        this.video.setHeight("200px");
        this.video.setControls(true);
        this.setWidth("300px");
        this.setHeight("200px");
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cssClassName", this.cssClassName);
        map.put("dataType", this.dataType);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("videoUrl", this.videoUrl);
        map.put("id", this.id);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.videoUrl = this.extractString(asPropertiesMap.get("videoUrl"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.dataType = this.extractString(asPropertiesMap.get("dataType"));
        this.populate(this.video);
    }

    private void populate(Video video) {
        if (video != null) {
            if (this.cssClassName != null) {
                video.setStyleName(this.cssClassName);
            }
            if (this.getHeight() != null) {
                video.setHeight(this.getHeight());
            }
            if (this.getWidth() != null) {
                video.setWidth(this.getWidth());
            }
            if (this.videoUrl != null && !"".equals(this.videoUrl)) {
                video.setSrc(this.videoUrl);
            }
            if (this.dataType != null) {
                video.getElement().setPropertyObject("type", (Object)this.dataType);
            }
            video.setControls(true);
        }
    }

    public FormItemRepresentation getRepresentation() {
        VideoRepresentation rep = (VideoRepresentation)super.getRepresentation((FormItemRepresentation)new VideoRepresentation());
        rep.setVideoUrl(this.videoUrl);
        rep.setCssClassName(this.cssClassName);
        rep.setDataType(this.dataType);
        rep.setId(this.id);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof VideoRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "VideoRepresentation"));
        }
        super.populate(rep);
        VideoRepresentation vrep = (VideoRepresentation)rep;
        this.videoUrl = vrep.getVideoUrl();
        this.cssClassName = vrep.getCssClassName();
        this.id = vrep.getId();
        this.dataType = vrep.getDataType();
        this.populate(this.video);
    }

    public FBFormItem cloneItem() {
        VideoFormItem clone = (VideoFormItem)super.cloneItem((FBFormItem)new VideoFormItem());
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.videoUrl = this.videoUrl;
        clone.cssClassName = this.cssClassName;
        clone.dataType = this.dataType;
        clone.id = this.id;
        clone.populate(clone.video);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> formData) {
        Video v = Video.createIfSupported();
        if (v == null) {
            return new Label(this.notSupported.getText());
        }
        this.populate(v);
        Object input = this.getInputValue(formData);
        if (v != null && input != null) {
            String url = input.toString();
            v.setSrc(url);
            if (url.endsWith(".ogv")) {
                v.getElement().setPropertyString("type", "video/ogg");
            } else if (url.endsWith(".mpeg") || url.endsWith(".mpg")) {
                v.getElement().setPropertyString("type", "video/mpeg");
            } else if (url.endsWith(".avi")) {
                v.getElement().setPropertyString("type", "video/avi");
            }
        }
        super.populateActions(v.getElement());
        return v;
    }

    public void setSourceReference(String sourceReference) {
        this.videoUrl = sourceReference;
        if (this.video != null) {
            this.video.setSrc(sourceReference);
        }
    }

    public String getSourceReference() {
        return this.videoUrl;
    }

    public List<String> getAllowedTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("mpeg");
        retval.add("mpg");
        retval.add("avi");
        retval.add("ogv");
        return retval;
    }
}

