/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.io.IOUtils;
import org.jbpm.formbuilder.server.xml.AssetDTO;
import org.jbpm.formbuilder.server.xml.PackageDTO;
import org.jbpm.formbuilder.server.xml.PackageListDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuvnorHelper {
    public static final String ENCODING = "UTF-8";
    private final String baseUrl;
    private final String user;
    private final String password;
    private final String domainName;
    private final int portNumber;
    private HttpClient client = null;

    public GuvnorHelper(String baseUrl, String user, String password) {
        String aux;
        this.baseUrl = baseUrl;
        this.user = user;
        this.password = password;
        int beginIndex = this.baseUrl.indexOf("://") + 3;
        int endIndex = this.baseUrl.indexOf("/", beginIndex);
        if (endIndex < 0) {
            endIndex = this.baseUrl.length();
        }
        if ((aux = this.baseUrl.substring(beginIndex, endIndex)).contains(":")) {
            String[] parts = aux.split(":");
            this.domainName = parts[0];
            this.portNumber = Integer.valueOf(parts[1]);
        } else {
            this.domainName = aux;
            this.portNumber = 80;
        }
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public HttpClient getHttpClient() {
        if (this.client == null) {
            return new HttpClient();
        }
        return this.client;
    }

    public GetMethod createGetMethod(String url) {
        return new GetMethod(url);
    }

    public DeleteMethod createDeleteMethod(String url) {
        return new DeleteMethod(url);
    }

    public PutMethod createPutMethod(String url) {
        return new PutMethod(url);
    }

    public PostMethod createPostMethod(String url) {
        return new PostMethod(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPackageNameByContentUUID(String uuid) throws JAXBException, IOException {
        HttpClient client = this.getHttpClient();
        GetMethod call = this.createGetMethod(this.getRestBaseUrl());
        try {
            this.setAuth(client, (HttpMethod)call);
            call.addRequestHeader("Accept", "application/xml");
            client.executeMethod((HttpMethod)call);
            PackageListDTO dto = (PackageListDTO)this.jaxbTransformation(PackageListDTO.class, call.getResponseBodyAsStream(), PackageListDTO.RELATED_CLASSES);
            for (PackageDTO pkg : dto.getPackage()) {
                if (!uuid.equals(pkg.getMetadata().getUuid())) continue;
                String string = pkg.getTitle();
                return string;
            }
            for (PackageDTO pkg : dto.getPackage()) {
                for (String url : pkg.getAssets()) {
                    GetMethod subCall = this.createGetMethod(url);
                    try {
                        subCall.setRequestHeader("Accept", "application/xml");
                        client.executeMethod((HttpMethod)subCall);
                        AssetDTO subDto = (AssetDTO)this.jaxbTransformation(AssetDTO.class, subCall.getResponseBodyAsStream(), AssetDTO.RELATED_CLASSES);
                        if (!subDto.getMetadata().getUuid().equals(uuid)) continue;
                        String string = pkg.getTitle();
                        return string;
                    }
                    finally {
                        subCall.releaseConnection();
                    }
                }
            }
        }
        finally {
            call.releaseConnection();
        }
        return null;
    }

    public <T> T jaxbTransformation(Class<T> retType, InputStream input, Class<?> ... boundTypes) throws JAXBException, IOException {
        String content = IOUtils.toString((InputStream)input);
        StringReader reader = new StringReader(content);
        JAXBContext ctx = JAXBContext.newInstance((Class[])boundTypes);
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        Object obj = unmarshaller.unmarshal((Reader)reader);
        return (T)obj;
    }

    public String jaxbSerializing(Object obj, Class<?> ... boundTypes) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])boundTypes);
        Marshaller marshaller = ctx.createMarshaller();
        StringWriter writer = new StringWriter();
        marshaller.marshal(obj, (Writer)writer);
        return writer.toString();
    }

    public void setAuth(HttpClient client, HttpMethod method) {
        if (this.notEmpty(this.user) && this.notEmpty(this.password)) {
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.user, this.password);
            AuthScope authScope = new AuthScope(this.domainName, this.portNumber, AuthScope.ANY_REALM);
            client.getState().setCredentials(authScope, (Credentials)defaultcreds);
        }
    }

    private boolean notEmpty(String s) {
        return s != null && !"".equals(s);
    }

    public String getApiSearchUrl(String pkgName) throws UnsupportedEncodingException {
        return this.baseUrl + "/org.drools.guvnor.Guvnor/api/packages/" + URLEncoder.encode(pkgName, ENCODING) + "/";
    }

    public String getRestBaseUrl() {
        return this.baseUrl + "/rest/packages/";
    }

    public String getUser() {
        return this.user;
    }
}

