/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.render.xsl;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.beanutils.PropertyUtils;
import org.jbpm.formapi.server.render.RendererException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Renderer
implements org.jbpm.formapi.server.render.Renderer {
    private final TransformerFactory factory = TransformerFactory.newInstance();

    public Object render(URL url, Map<String, Object> inputData) throws RendererException {
        try {
            StreamSource template = new StreamSource(url.openStream());
            Transformer transformer = this.factory.newTransformer(template);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            StreamSource inputSource = new StreamSource(this.toInputString(inputData));
            transformer.transform(inputSource, result);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RendererException("I/O problem rendering " + url, (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new RendererException("transformer configuration problem rendering " + url, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new RendererException("transformer problem rendering " + url, (Throwable)e);
        }
        finally {
            new File(url.getFile()).delete();
        }
    }

    protected String toInputString(Map<String, Object> inputData) {
        StringBuilder builder = new StringBuilder("<?xml version=\"1.0\"?>\n");
        if (inputData != null) {
            for (Map.Entry<String, Object> entry : inputData.entrySet()) {
                builder.append("<").append(entry.getKey()).append(">").append(this.toString(entry.getValue())).append("</").append(entry.getKey()).append(">\n");
            }
        }
        return builder.toString();
    }

    protected String toString(Object value) {
        StringBuilder builder = new StringBuilder();
        if (value instanceof String || value instanceof Number) {
            builder.append(value);
        } else if (value instanceof Map) {
            builder.append(this.toInputString((Map)value));
        } else if (value instanceof Collection) {
            for (Object obj : (Collection)value) {
                builder.append(this.toString(obj));
            }
        } else {
            HashMap<String, Object> metaMap = new HashMap<String, Object>();
            for (Field field : value.getClass().getFields()) {
                try {
                    metaMap.put(field.getName(), PropertyUtils.getProperty((Object)value, (String)field.getName()));
                }
                catch (Exception e) {
                    metaMap.put(field.getName(), "");
                }
            }
            builder.append(this.toInputString(metaMap));
        }
        return builder.toString();
    }
}

