/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.shared.form;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.shared.api.FBScript;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formapi.shared.api.Formatter;
import org.jbpm.formapi.shared.api.InputData;
import org.jbpm.formapi.shared.api.OutputData;
import org.jbpm.formapi.shared.api.items.CompleteButtonRepresentation;
import org.jbpm.formapi.shared.api.items.HeaderRepresentation;
import org.jbpm.formapi.shared.api.items.LabelRepresentation;
import org.jbpm.formapi.shared.api.items.TableRepresentation;
import org.jbpm.formapi.shared.api.items.TextFieldRepresentation;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;
import org.jbpm.formbuilder.shared.task.TaskRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseFormDefinitionService {
    private static final String FORM_ID_PREFIX = "formDefinition_";
    private static final String ITEM_ID_PREFIX = "formItemDefinition_";
    private Map<String, List<String>> effectsForItem = new HashMap();
    private Map<String, List<String>> actionsForItem = new HashMap();

    protected boolean updateFormName(FormRepresentation form) {
        if (form.getName() == null || "null".equals(form.getName()) || "".equals(form.getName())) {
            form.setName(FORM_ID_PREFIX + System.currentTimeMillis());
            return false;
        }
        if (!form.getName().startsWith(FORM_ID_PREFIX)) {
            form.setName(FORM_ID_PREFIX + form.getName());
            return false;
        }
        return true;
    }

    protected boolean updateItemName(String formItemName, StringBuilder returnName) {
        if (formItemName == null || "null".equals(formItemName) || "".equals(formItemName)) {
            returnName.append(ITEM_ID_PREFIX).append(System.currentTimeMillis());
            return false;
        }
        if (!formItemName.startsWith(ITEM_ID_PREFIX)) {
            returnName.append(ITEM_ID_PREFIX).append(formItemName);
            return false;
        }
        returnName.append(formItemName);
        return true;
    }

    protected boolean isItemName(String assetId) {
        return assetId.startsWith(ITEM_ID_PREFIX) && assetId.endsWith(".json");
    }

    protected boolean isFormName(String assetId) {
        return assetId.endsWith(".formdef");
    }

    public void putEffectsForItem(String className, List<String> effectClassNames) {
        this.effectsForItem.put(className, effectClassNames);
    }

    public void putActionsForItem(String className, List<String> actionClassNames) {
        this.actionsForItem.put(className, actionClassNames);
    }

    protected <T> Map<String, T> asMapOfNull(List<String> keys, Class<T> type) {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        if (keys != null) {
            for (String key : keys) {
                retval.put(key, null);
            }
        }
        return retval;
    }

    public List<String> get(Map<String, List<String>> map, String keyPart) {
        for (String key : map.keySet()) {
            if (!key.contains(keyPart)) continue;
            return map.get(key);
        }
        return null;
    }

    public FormRepresentation createFormFromTask(TaskRef task) {
        List outputs;
        List inputs;
        if (task == null) {
            return null;
        }
        List headerEffects = this.get(this.effectsForItem, "HeaderMenuItem");
        List tableEffects = this.get(this.effectsForItem, "TableLayoutMenuItem");
        List labelEffects = this.get(this.effectsForItem, "LabelMenuItem");
        List textfieldEffects = this.get(this.effectsForItem, "TextFieldMenuItem");
        List completeButtonEffects = this.get(this.effectsForItem, "CompleteButtonMenuItem");
        List headerActions = this.get(this.actionsForItem, "HeaderMenuItem");
        List tableActions = this.get(this.actionsForItem, "TableLayoutMenuItem");
        List labelActions = this.get(this.actionsForItem, "LabelMenuItem");
        List textfieldActions = this.get(this.actionsForItem, "TextFieldMenuItem");
        List completeButtonActions = this.get(this.actionsForItem, "CompleteButtonMenuItem");
        FormRepresentation form = new FormRepresentation();
        form.setInputs(this.toInputDataMap(task.getInputs()));
        form.setOutputs(this.toOutputDataMap(task.getOutputs()));
        if (task.getTaskId() != null) {
            HeaderRepresentation header = new HeaderRepresentation();
            header.setValue("Task: " + task.getTaskId());
            header.setEffectClasses(headerEffects);
            header.setEventActions(this.asMapOfNull(headerActions, FBScript.class));
            form.addFormItem((FormItemRepresentation)header);
        }
        if ((inputs = task.getInputs()) != null && !inputs.isEmpty()) {
            TableRepresentation tableOfInputs = new TableRepresentation();
            tableOfInputs.setRows(Integer.valueOf(inputs.size()));
            tableOfInputs.setColumns(Integer.valueOf(2));
            tableOfInputs.setHeight("" + inputs.size() * 30 + "px");
            tableOfInputs.setEffectClasses(tableEffects);
            tableOfInputs.setEventActions(this.asMapOfNull(tableActions, FBScript.class));
            for (int index = 0; index < inputs.size(); ++index) {
                TaskPropertyRef input = (TaskPropertyRef)inputs.get(index);
                LabelRepresentation labelName = new LabelRepresentation();
                labelName.setEventActions(this.asMapOfNull(labelActions, FBScript.class));
                labelName.setEffectClasses(labelEffects);
                labelName.setValue(input.getName());
                labelName.setWidth("100px");
                tableOfInputs.setElement(index, 0, (FormItemRepresentation)labelName);
                LabelRepresentation labelValue = new LabelRepresentation();
                labelValue.setEventActions(this.asMapOfNull(labelActions, FBScript.class));
                labelValue.setEffectClasses(labelEffects);
                labelValue.setWidth("200px");
                InputData data = new InputData();
                data.setName(input.getName());
                data.setValue(input.getSourceExpresion());
                data.setMimeType("multipart/form-data");
                data.setFormatter((Formatter)new /* Unavailable Anonymous Inner Class!! */);
                labelValue.setInput(data);
                labelValue.setValue("{variable}");
                tableOfInputs.setElement(index, 1, (FormItemRepresentation)labelValue);
            }
            LabelRepresentation labelInputs = new LabelRepresentation();
            labelInputs.setEventActions(this.asMapOfNull(labelActions, FBScript.class));
            labelInputs.setEffectClasses(labelEffects);
            labelInputs.setValue("Inputs:");
            form.addFormItem((FormItemRepresentation)labelInputs);
            form.addFormItem((FormItemRepresentation)tableOfInputs);
        }
        if ((outputs = task.getOutputs()) != null && !outputs.isEmpty()) {
            TableRepresentation tableOfOutputs = new TableRepresentation();
            tableOfOutputs.setRows(Integer.valueOf(outputs.size()));
            tableOfOutputs.setColumns(Integer.valueOf(2));
            tableOfOutputs.setHeight("" + outputs.size() * 30 + "px");
            tableOfOutputs.setEffectClasses(tableEffects);
            tableOfOutputs.setEventActions(this.asMapOfNull(tableActions, FBScript.class));
            for (int index = 0; index < outputs.size(); ++index) {
                TaskPropertyRef output = (TaskPropertyRef)outputs.get(index);
                LabelRepresentation labelName = new LabelRepresentation();
                labelName.setEventActions(this.asMapOfNull(labelActions, FBScript.class));
                labelName.setEffectClasses(labelEffects);
                labelName.setValue(output.getName());
                labelName.setWidth("100px");
                tableOfOutputs.setElement(index, 0, (FormItemRepresentation)labelName);
                TextFieldRepresentation textField = new TextFieldRepresentation();
                textField.setEventActions(this.asMapOfNull(textfieldActions, FBScript.class));
                textField.setWidth("200px");
                textField.setEffectClasses(textfieldEffects);
                OutputData data = new OutputData();
                data.setName(output.getName());
                data.setValue(output.getSourceExpresion());
                data.setMimeType("multipart/form-data");
                data.setFormatter((Formatter)new /* Unavailable Anonymous Inner Class!! */);
                textField.setOutput(data);
                tableOfOutputs.setElement(index, 1, (FormItemRepresentation)textField);
            }
            LabelRepresentation labelOutputs = new LabelRepresentation();
            labelOutputs.setEventActions(this.asMapOfNull(labelActions, FBScript.class));
            labelOutputs.setEffectClasses(labelEffects);
            labelOutputs.setValue("Outputs:");
            form.addFormItem((FormItemRepresentation)labelOutputs);
            form.addFormItem((FormItemRepresentation)tableOfOutputs);
        }
        CompleteButtonRepresentation completeButton = new CompleteButtonRepresentation();
        completeButton.setText("Complete");
        completeButton.setEffectClasses(completeButtonEffects);
        completeButton.setEventActions(this.asMapOfNull(completeButtonActions, FBScript.class));
        form.addFormItem((FormItemRepresentation)completeButton);
        form.setAction("complete");
        form.setEnctype("multipart/form-data");
        form.setMethod("POST");
        form.setName(task.getTaskId() + "AutoForm");
        form.setProcessName(task.getProcessId());
        form.setTaskId(task.getTaskId());
        return form;
    }

    protected Map<String, InputData> toInputDataMap(List<TaskPropertyRef> inputs) {
        HashMap<String, InputData> retval = new HashMap<String, InputData>();
        for (TaskPropertyRef ref : inputs) {
            InputData in = new InputData();
            in.setName(ref.getName());
            retval.put(ref.getName(), in);
        }
        return retval;
    }

    protected Map<String, OutputData> toOutputDataMap(List<TaskPropertyRef> outputs) {
        HashMap<String, OutputData> retval = new HashMap<String, OutputData>();
        for (TaskPropertyRef ref : outputs) {
            OutputData out = new OutputData();
            out.setName(ref.getName());
            retval.put(ref.getName(), out);
        }
        return retval;
    }
}

