/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.command;

import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.RootPanel;
import com.gwtent.reflection.client.Reflectable;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.FormBuilderService;
import org.jbpm.formbuilder.client.bus.GetFormRepresentationEvent;
import org.jbpm.formbuilder.client.bus.GetFormRepresentationResponseEvent;
import org.jbpm.formbuilder.client.command.BaseCommand;
import org.jbpm.formbuilder.client.menu.FormDataPopupPanel;
import org.jbpm.formbuilder.client.messages.I18NConstants;

@Reflectable
public class SaveFormCommand
implements BaseCommand {
    private static final String SAVE_TYPE = SaveFormCommand.class.getName();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final FormBuilderService service = FormBuilderGlobals.getInstance().getService();
    private MenuItem item = null;

    public SaveFormCommand() {
        this.bus.addHandler(GetFormRepresentationResponseEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showSavePanel(FormRepresentation form) {
        if (form.getName() == null || "".equals(form.getName())) {
            FormDataPopupPanel panel = new FormDataPopupPanel(true);
            panel.setAction(form.getAction());
            panel.setEnctype(form.getEnctype());
            panel.setMethod(form.getMethod());
            panel.setName(form.getName());
            panel.setTaskId(form.getTaskId());
            panel.setModal(true);
            panel.setPopupPosition(RootPanel.getBodyElement().getClientWidth() / 2 - 150, RootPanel.getBodyElement().getClientHeight() / 2 - 150);
            panel.show();
            panel.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void saveForm(FormDataPopupPanel panel, FormRepresentation form) {
        String formName = panel.getFormName();
        if (formName != null && !"".equals(formName)) {
            try {
                form.populate(panel.getFormName(), panel.getTaskId(), panel.getProcessId(), panel.getAction(), panel.getMethod(), panel.getEnctype(), panel.getDocumentation());
                this.service.saveForm(form);
                this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.INFO, this.i18n.FormSavedSuccessfully(form.getName())));
            }
            catch (FormBuilderException e) {
                this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.ProblemSavingForm(form.getName()), (Throwable)e));
            }
        } else {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.DefineFormNameFirst()));
        }
    }

    public void execute() {
        this.bus.fireEvent((GwtEvent)new GetFormRepresentationEvent(SAVE_TYPE));
    }

    public void setItem(MenuItem item) {
        this.item = item;
        item.setEnabled(true);
    }

    public void setEmbeded(String profile) {
        if (this.item != null && profile != null && "guvnor".equals(profile)) {
            this.item.getParentMenu().removeItem(this.item);
        }
    }

    static /* synthetic */ String access$000() {
        return SAVE_TYPE;
    }

    static /* synthetic */ void access$100(SaveFormCommand x0, FormRepresentation x1) {
        x0.showSavePanel(x1);
    }
}

