/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect.view;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.FormBuilderService;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesDataPanel
extends ScrollPanel {
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final FormBuilderService server = FormBuilderGlobals.getInstance().getService();
    private boolean isEmpty = true;
    FlexTable table = new FlexTable();
    private String selection = null;

    public FilesDataPanel() {
        this.setHeight("200px");
        this.setWidget((Widget)this.table);
    }

    public void setFiles(List<String> urls) {
        this.table.clear();
        if (urls != null && !urls.isEmpty()) {
            this.isEmpty = false;
            for (int row = 0; row < urls.size(); ++row) {
                String url = urls.get(row);
                FocusPanel labelPanel = this.createLabelPanel(url);
                this.table.setWidget(row, 0, (Widget)labelPanel);
                Element rowElem = this.table.getRowFormatter().getElement(row);
                this.table.setWidget(row, 1, (Widget)this.createDeleteButton(rowElem, url));
            }
        } else {
            this.table.setWidget(0, 0, (Widget)new Label(this.i18n.NoFilesFound()));
        }
    }

    private FocusPanel createLabelPanel(String url) {
        FocusPanel panel = new FocusPanel();
        panel.setStyleName("fbFilesDataPanel");
        panel.addFocusHandler((FocusHandler)new /* Unavailable Anonymous Inner Class!! */);
        panel.setWidget((Widget)new Label(this.toFileName(url)));
        return panel;
    }

    private void deselectAllLabels() {
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            Widget widget = this.table.getWidget(row, 0);
            if (widget == null || !widget.getStyleName().equals("fbFilesDataPanelSelected")) continue;
            widget.setStyleName("fbFilesDataPanel");
        }
    }

    private Button createDeleteButton(Element rowElem, String url) {
        return new Button(this.i18n.RemoveButton(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public String toFileName(String url) {
        return url.substring(url.lastIndexOf(47));
    }

    public void addNewFile(String url) {
        if (!this.contains(url)) {
            FocusPanel labelPanel = this.createLabelPanel(url);
            if (this.isEmpty) {
                this.table.clear();
            }
            int row = this.table.getRowCount();
            this.table.setWidget(row, 0, (Widget)labelPanel);
            Element rowElem = this.table.getRowFormatter().getElement(row);
            this.table.setWidget(row, 1, (Widget)this.createDeleteButton(rowElem, url));
            labelPanel.setFocus(true);
            this.setSelection(url);
        }
    }

    private boolean contains(String url) {
        String fileName = this.toFileName(url);
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            Label label;
            FocusPanel labelPanel = (FocusPanel)this.table.getWidget(row, 0);
            if (labelPanel == null || labelPanel.getWidget() == null || !(label = (Label)labelPanel.getWidget()).getText().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ void access$000(FilesDataPanel x0) {
        x0.deselectAllLabels();
    }

    static /* synthetic */ I18NConstants access$100(FilesDataPanel x0) {
        return x0.i18n;
    }

    static /* synthetic */ FormBuilderService access$200(FilesDataPanel x0) {
        return x0.server;
    }

    static /* synthetic */ EventBus access$300(FilesDataPanel x0) {
        return x0.bus;
    }
}

