/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.I18NFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.CompleteButtonRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.I18NUtils;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class CompleteButtonFormItem
extends FBFormItem
implements I18NFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private Button button = new Button(this.i18n.CompleteButton());
    private final I18NUtils utils = new I18NUtils();
    private String innerText = this.i18n.CompleteButton();
    private String name;
    private String id;
    private String cssStyleName;

    public CompleteButtonFormItem() {
        this(new ArrayList());
    }

    public CompleteButtonFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.button);
        this.setHeight("27px");
        this.setWidth("100px");
        this.button.setSize(this.getWidth(), this.getHeight());
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.innerText = this.extractString(asPropertiesMap.get("innerText"));
        this.cssStyleName = this.extractString(asPropertiesMap.get("cssStyleName"));
        this.populate(this.button);
    }

    private void populate(Button button) {
        if (this.getHeight() != null) {
            button.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            button.setWidth(this.getWidth());
        }
        if (this.innerText != null) {
            button.setText(this.innerText);
        }
        if (this.cssStyleName != null) {
            button.setStyleName(this.cssStyleName);
        }
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("innerText", this.innerText);
        map.put("cssStyleName", this.cssStyleName);
        map.put("name", this.name);
        map.put("id", this.id);
        return map;
    }

    public FormItemRepresentation getRepresentation() {
        CompleteButtonRepresentation rep = (CompleteButtonRepresentation)super.getRepresentation((FormItemRepresentation)new CompleteButtonRepresentation());
        rep.setText(this.innerText);
        rep.setName(this.name);
        rep.setId(this.id);
        rep.setI18n(this.getI18nMap());
        rep.setFormat(this.getFormat() == null ? null : this.getFormat().toString());
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof CompleteButtonRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "CompleteButtonRepresentation"));
        }
        super.populate(rep);
        CompleteButtonRepresentation crep = (CompleteButtonRepresentation)rep;
        this.innerText = crep.getText();
        this.name = crep.getName();
        this.id = crep.getId();
        this.saveI18nMap(crep.getI18n());
        if (crep.getFormat() != null && !"".equals(crep.getFormat())) {
            this.setFormat(I18NFormItem.Format.valueOf((String)crep.getFormat()));
        }
        this.populate(this.button);
    }

    public FBFormItem cloneItem() {
        CompleteButtonFormItem clone = new CompleteButtonFormItem(this.getFormEffects());
        clone.cssStyleName = this.cssStyleName;
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.id = this.id;
        clone.innerText = this.innerText;
        clone.saveI18nMap(this.getI18nMap());
        clone.name = this.name;
        clone.populate(clone.button);
        clone.setFormat(this.getFormat());
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        Button bt = new Button();
        this.populate(bt);
        Object input = this.getInputValue(data);
        if (input != null) {
            bt.setText(input.toString());
        }
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            ButtonElement.as((Element)bt.getElement()).setName(this.getOutput().getName());
        }
        bt.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        super.populateActions(bt.getElement());
        return bt;
    }

    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    public void saveI18nMap(Map<String, String> i18nMap) {
        if (i18nMap != null) {
            String defaultI18n = i18nMap.get("default");
            if (defaultI18n != null && !"".equals(defaultI18n)) {
                this.innerText = defaultI18n;
                this.populate(this.button);
            }
            this.utils.saveI18nMap(i18nMap);
        }
    }

    public I18NFormItem.Format getFormat() {
        return this.utils.getFormat();
    }

    public void setFormat(I18NFormItem.Format format) {
        this.utils.setFormat(format);
    }
}

