/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.HorizontalPanelRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class HorizontalLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private HorizontalPanel panel = new HorizontalPanel();
    private Integer borderWidth;
    private Integer spacing;
    private String cssClassName;
    private String horizontalAlignment;
    private String verticalAlignment;
    private String title;
    private String id;

    public HorizontalLayoutFormItem() {
        this(new ArrayList());
    }

    public HorizontalLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.panel.setBorderWidth(1);
        this.add((Widget)this.panel);
        this.setSize("90px", "30px");
        this.panel.setSize(this.getWidth(), this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("borderWidth", this.borderWidth);
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("spacing", this.spacing);
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        formItemPropertiesMap.put("horizontalAlignment", this.horizontalAlignment);
        formItemPropertiesMap.put("verticalAlignment", this.verticalAlignment);
        formItemPropertiesMap.put("title", this.title);
        formItemPropertiesMap.put("id", this.id);
        return formItemPropertiesMap;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.borderWidth = this.extractInt(asPropertiesMap.get("borderWidth"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.spacing = this.extractInt(asPropertiesMap.get("spacing"));
        this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
        this.horizontalAlignment = this.extractString(asPropertiesMap.get("horizontalAlignment"));
        this.verticalAlignment = this.extractString(asPropertiesMap.get("verticalAlignment"));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.panel);
    }

    private void populate(HorizontalPanel panel) {
        if (this.borderWidth != null) {
            panel.setBorderWidth(this.borderWidth.intValue());
        }
        if (this.getHeight() != null && !"".equals(this.getHeight())) {
            panel.setHeight(this.getHeight());
        }
        if (this.getWidth() != null && !"".equals(this.getWidth())) {
            panel.setWidth(this.getWidth());
        }
        if (this.spacing != null) {
            panel.setSpacing(this.spacing.intValue());
        }
        if (this.cssClassName != null) {
            panel.setStyleName(this.cssClassName);
        }
        if (this.horizontalAlignment != null) {
            try {
                HasDirection.Direction d = HasDirection.Direction.valueOf((String)this.horizontalAlignment);
                panel.setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant.startOf((HasDirection.Direction)d));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.title != null) {
            panel.setTitle(this.title);
        }
    }

    public HasWidgets getPanel() {
        return this.panel;
    }

    public FormItemRepresentation getRepresentation() {
        HorizontalPanelRepresentation rep = (HorizontalPanelRepresentation)super.getRepresentation((FormItemRepresentation)new HorizontalPanelRepresentation());
        rep.setBorderWidth(this.borderWidth);
        rep.setCssClassName(this.cssClassName);
        rep.setHorizontalAlignment(this.horizontalAlignment);
        rep.setId(this.id);
        rep.setSpacing(this.spacing);
        rep.setTitle(this.title);
        rep.setVerticalAlignment(this.verticalAlignment);
        for (FBFormItem item : this.getItems()) {
            rep.addItem(item.getRepresentation());
        }
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof HorizontalPanelRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "HorizontalPanelRepresentation"));
        }
        super.populate(rep);
        HorizontalPanelRepresentation hrep = (HorizontalPanelRepresentation)rep;
        this.borderWidth = hrep.getBorderWidth();
        this.cssClassName = hrep.getCssClassName();
        this.horizontalAlignment = hrep.getHorizontalAlignment();
        this.id = hrep.getId();
        this.spacing = hrep.getSpacing();
        this.title = hrep.getTitle();
        this.verticalAlignment = hrep.getVerticalAlignment();
        this.panel.clear();
        super.getItems().clear();
        this.populate(this.panel);
        if (hrep.getItems() != null) {
            for (FormItemRepresentation item : hrep.getItems()) {
                this.add(LayoutFormItem.createItem((FormItemRepresentation)item));
            }
        }
    }

    public FBFormItem cloneItem() {
        HorizontalLayoutFormItem clone = new HorizontalLayoutFormItem(this.getFormEffects());
        clone.borderWidth = this.borderWidth;
        clone.cssClassName = this.cssClassName;
        clone.setHeight(this.getHeight());
        clone.horizontalAlignment = this.horizontalAlignment;
        clone.id = this.id;
        clone.spacing = this.spacing;
        clone.title = this.title;
        clone.verticalAlignment = this.verticalAlignment;
        clone.setWidth(this.getWidth());
        clone.populate(clone.panel);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        HorizontalPanel hp = new HorizontalPanel();
        this.populate(hp);
        super.populateActions(hp.getElement());
        for (FBFormItem item : this.getItems()) {
            hp.add(item.cloneDisplay(data));
        }
        return hp;
    }

    public boolean add(FBFormItem item) {
        this.panel.add((Widget)item);
        return super.add(item);
    }

    public void add(PhantomPanel phantom, int x, int y) {
        Widget beforeWidget = null;
        for (Widget widget : this.panel) {
            int left = widget.getAbsoluteLeft();
            int right = left + widget.getOffsetWidth();
            if (x <= left || x >= right) continue;
            beforeWidget = widget;
            break;
        }
        if (beforeWidget == null) {
            this.panel.add((Widget)phantom);
        } else {
            int index = this.panel.getWidgetIndex(beforeWidget);
            this.panel.insert((Widget)phantom, index);
        }
    }

    public void replacePhantom(FBFormItem item) {
        PhantomPanel phantom = null;
        for (Widget widget : this.panel) {
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom == null) {
            this.add(item);
        } else {
            int index = this.panel.getWidgetIndex(phantom);
            this.panel.remove((Widget)phantom);
            super.insert(index, item);
        }
    }
}

