/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.common.panels.RichTextEditor;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.RichTextEditorRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class RichTextEditorFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private RichTextEditor editor = new RichTextEditor();
    private String html = "";

    public RichTextEditorFormItem() {
        this(new ArrayList());
    }

    public RichTextEditorFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.editor.getEditorToolbar().setHeight("50px");
        this.editor.setSize("400px", "200px");
        this.setSize("400px", "200px");
        this.editor.setHTML(this.html);
        this.add((Widget)this.editor);
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("html", this.editor.getHTML());
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.html = this.extractString(asPropertiesMap.get("html"));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.populate(this.editor);
    }

    private void populate(RichTextEditor editor) {
        if (this.getHeight() != null && !"".equals(this.getHeight())) {
            editor.setHeight(this.getHeight());
        }
        if (this.getWidth() != null && !"".equals(this.getWidth())) {
            editor.setWidth(this.getWidth());
        }
        if (this.html != null && !"".equals(this.html)) {
            editor.setHTML(this.html);
        }
    }

    public FormItemRepresentation getRepresentation() {
        RichTextEditorRepresentation rep = (RichTextEditorRepresentation)super.getRepresentation((FormItemRepresentation)new RichTextEditorRepresentation());
        rep.setHtml(this.html);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof RichTextEditorRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "RichTextEditorRepresentation"));
        }
        super.populate(rep);
        RichTextEditorRepresentation rrep = (RichTextEditorRepresentation)rep;
        this.html = rrep.getHtml();
        if (rrep.getWidth() != null && !"".equals(rrep.getWidth())) {
            this.setWidth(rrep.getWidth());
        }
        if (rrep.getHeight() != null && !"".equals(rrep.getHeight())) {
            this.setHeight(rrep.getHeight());
        }
        this.populate(this.editor);
    }

    public FBFormItem cloneItem() {
        RichTextEditorFormItem clone = (RichTextEditorFormItem)super.cloneItem((FBFormItem)new RichTextEditorFormItem(this.getFormEffects()));
        clone.html = this.html;
        this.populate(clone.editor);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        RichTextEditor display = new RichTextEditorFormItem().editor;
        this.populate(display);
        Object input = this.getInputValue(data);
        if (input != null) {
            display.setHTML(input.toString());
        }
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            display.setName(this.getOutput().getName());
        }
        super.populateActions(display.getElement());
        return display;
    }
}

