/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.command;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.gwt.mosaic.ui.client.WindowPanel;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.FormBuilderService;
import org.jbpm.formbuilder.client.UIUtils;
import org.jbpm.formbuilder.client.bus.GetFormRepresentationEvent;
import org.jbpm.formbuilder.client.bus.GetFormRepresentationResponseEvent;
import org.jbpm.formbuilder.client.bus.PreviewFormResponseEvent;
import org.jbpm.formbuilder.client.command.BaseCommand;
import org.jbpm.formbuilder.client.command.InputMapPanel;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreviewFormCommand
implements BaseCommand {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    protected final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final FormBuilderService server = FormBuilderGlobals.getInstance().getService();
    private final String saveType;

    public PreviewFormCommand(String saveType) {
        this.saveType = saveType;
        this.bus.addHandler(GetFormRepresentationResponseEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(PreviewFormResponseEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setItem(MenuItem item) {
    }

    public void setEmbeded(String profile) {
    }

    public void execute() {
        this.bus.fireEvent((GwtEvent)new GetFormRepresentationEvent(this.saveType));
    }

    protected void refreshPopup(String url) {
        WindowPanel window = UIUtils.createWindow((String)("Preview as " + this.saveType));
        window.getDesktopPanel().addStyleName("formDisplay");
        Frame content = new Frame(url);
        window.setWidget((Widget)content);
        int height = RootPanel.getBodyElement().getClientHeight();
        int width = RootPanel.getBodyElement().getClientWidth();
        int left = RootPanel.getBodyElement().getAbsoluteLeft();
        int top = RootPanel.getBodyElement().getAbsoluteTop();
        content.setPixelSize(width - 200, height - 200);
        window.showModal();
        window.setPopupPosition(left + 100, top + 100);
        window.setPixelSize(width - 200, height - 200);
    }

    public void popupInputMapPanel(FormRepresentation form) {
        Map inputs = form.getInputs();
        if (inputs == null || inputs.isEmpty()) {
            this.saveForm(form, null);
        } else {
            InputMapPanel popup = new InputMapPanel(inputs);
            popup.addOkHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            int height = RootPanel.getBodyElement().getClientHeight();
            int width = RootPanel.getBodyElement().getClientWidth();
            popup.setPopupPosition(width / 2 - 150, height / 2 - 150);
            popup.show();
        }
    }

    public void saveForm(FormRepresentation form, Map<String, Object> inputMap) {
        try {
            this.server.generateForm(form, this.saveType, inputMap);
        }
        catch (FormBuilderException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.UnexpectedWhilePreviewForm(this.saveType), (Throwable)e));
        }
    }
}

