/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.HashMap;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.bus.UndoableEvent;
import org.jbpm.formbuilder.client.bus.UndoableHandler;
import org.jbpm.formbuilder.client.messages.I18NConstants;

@Reflectable
public class HorizontalAlignmentFormEffect
extends FBFormEffect {
    private ListBox alignmentBox = new ListBox();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();

    public HorizontalAlignmentFormEffect() {
        super(FormBuilderGlobals.getInstance().getI18n().HorizontalAlignment(), true);
        this.alignmentBox.addItem(this.i18n.AlignLeft(), this.i18n.AlignLeft());
        this.alignmentBox.addItem(this.i18n.AlignRight(), this.i18n.AlignRight());
        this.alignmentBox.addItem(this.i18n.AlignCenter(), this.i18n.AlignCenter());
        this.alignmentBox.addItem(this.i18n.AlignJustify(), this.i18n.AlignJustify());
    }

    protected void createStyles() {
        int index = this.alignmentBox.getSelectedIndex();
        String value = this.alignmentBox.getValue(index);
        Widget widget = this.getWidget();
        if (widget instanceof HasHorizontalAlignment) {
            HasHorizontalAlignment hw = (HasHorizontalAlignment)widget;
            HasHorizontalAlignment.HorizontalAlignmentConstant align = null;
            if (this.i18n.AlignLeft().equals(value)) {
                align = HasHorizontalAlignment.ALIGN_LEFT;
            } else if (this.i18n.AlignRight().equals(value)) {
                align = HasHorizontalAlignment.ALIGN_RIGHT;
            } else if (this.i18n.AlignCenter().equals(value)) {
                align = HasHorizontalAlignment.ALIGN_CENTER;
            } else if (this.i18n.AlignJustify().equals(value)) {
                align = HasHorizontalAlignment.ALIGN_JUSTIFY;
            }
            HashMap<String, Object> dataSnapshot = new HashMap<String, Object>();
            dataSnapshot.put("oldAlignment", hw.getHorizontalAlignment());
            dataSnapshot.put("newAlignment", align);
            dataSnapshot.put("hwidget", hw);
            this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, (UndoableHandler)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    public void remove(FBFormItem item) {
        super.remove(item);
        Widget widget = this.getWidget();
        if (widget instanceof HasHorizontalAlignment) {
            HasHorizontalAlignment hw = (HasHorizontalAlignment)widget;
            hw.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_DEFAULT);
        }
    }

    public boolean isValidForItem(FBFormItem item) {
        return item.getWidget() != null && item.getWidget() instanceof HasHorizontalAlignment;
    }

    public PopupPanel createPanel() {
        PopupPanel panel = new PopupPanel();
        panel.setSize("300px", "200px");
        VerticalPanel vPanel = new VerticalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)new Label(this.i18n.Alignment()));
        this.alignmentBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        hPanel.add((Widget)this.alignmentBox);
        Button fontSizeButton = new Button(this.i18n.ConfirmButton());
        fontSizeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        vPanel.add((Widget)this.alignmentBox);
        vPanel.add((Widget)fontSizeButton);
        panel.add((Widget)vPanel);
        return panel;
    }
}

