/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.HashMap;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.RoleUtils;
import org.jbpm.formbuilder.client.bus.UndoableEvent;
import org.jbpm.formbuilder.client.bus.UndoableHandler;
import org.jbpm.formbuilder.client.menu.items.CustomMenuItem;
import org.jbpm.formbuilder.client.messages.I18NConstants;

@Reflectable
public class SaveAsMenuOptionFormEffect
extends FBFormEffect {
    private String newMenuOptionName;
    private String groupName;
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();

    public SaveAsMenuOptionFormEffect() {
        super("Save as menu option", true);
    }

    public void setNewMenuOptionName(String newMenuOptionName) {
        this.newMenuOptionName = newMenuOptionName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    protected void createStyles() {
        FBFormItem formItem = super.getItem();
        CustomMenuItem menuItem = new CustomMenuItem(formItem.getRepresentation(), this.newMenuOptionName, formItem.getFormEffects(), this.groupName);
        if (formItem.getEventActions() != null) {
            for (String evtName : formItem.getEventActions().keySet()) {
                menuItem.addAllowedEvent(evtName);
            }
        }
        HashMap<String, Object> dataSnapshot = new HashMap<String, Object>();
        dataSnapshot.put("menuItem", menuItem);
        dataSnapshot.put("groupName", this.groupName);
        this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, (UndoableHandler)new /* Unavailable Anonymous Inner Class!! */));
    }

    public PopupPanel createPanel() {
        PopupPanel panel = new PopupPanel(true);
        panel.setSize("250px", "90px");
        VerticalPanel vPanel = new VerticalPanel();
        Grid grid = new Grid(2, 2);
        TextBox optionNameBox = new TextBox();
        TextBox groupNameBox = new TextBox();
        grid.setWidget(0, 0, (Widget)new Label(this.i18n.MenuOptionName()));
        grid.setWidget(0, 1, (Widget)optionNameBox);
        grid.setWidget(1, 0, (Widget)new Label(this.i18n.MenuOptionGroup()));
        grid.setWidget(1, 1, (Widget)groupNameBox);
        Button applyButton = new Button(this.i18n.ConfirmButton());
        applyButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        vPanel.add((Widget)grid);
        vPanel.add((Widget)applyButton);
        panel.add((Widget)vPanel);
        return panel;
    }

    public boolean isValidForItem(FBFormItem item) {
        return super.isValidForItem(item) && RoleUtils.getInstance().hasDesignPrivileges();
    }
}

