/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.effect.view;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jbpm.formapi.client.validation.FBValidationItem;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

public class ValidationEditionPanel
extends VerticalPanel {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final Grid editionGrid = new Grid(1, 1);
    private final Map<String, HasValue<String>> validationProperties = new HashMap();
    private final Button okButton = new Button(this.i18n.OkButton());
    private FBValidationItem currentValidation = null;

    public ValidationEditionPanel() {
        this.add((Widget)this.editionGrid);
        HorizontalPanel hPanel = new HorizontalPanel();
        Button resetButton = new Button(this.i18n.ResetButton());
        resetButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        hPanel.add((Widget)resetButton);
        this.okButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        hPanel.add((Widget)this.okButton);
        this.add((Widget)hPanel);
    }

    public void onCommitEdition(ClickHandler handler) {
        this.okButton.addClickHandler(handler);
    }

    public void setCurrentValidation(FBValidationItem newValidation) {
        this.currentValidation = newValidation;
        Widget display = newValidation.createDisplay();
        if (display == null) {
            Map newValidationProperties = newValidation.getPropertiesMap();
            int propertiesSize = newValidationProperties == null ? 0 : newValidationProperties.size();
            this.editionGrid.clear();
            this.editionGrid.resize(propertiesSize, 3);
            this.validationProperties.clear();
            if (newValidationProperties != null) {
                Iterator iter = newValidationProperties.entrySet().iterator();
                int index = 0;
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.editionGrid.setWidget(index, 0, (Widget)new Label((String)entry.getKey() + ": "));
                    this.editionGrid.setWidget(index, 1, (Widget)new HTML("&nbsp;&nbsp;&nbsp;"));
                    this.validationProperties.put(entry.getKey(), entry.getValue());
                    this.editionGrid.setWidget(index, 2, (Widget)entry.getValue());
                    ++index;
                }
            }
        } else {
            this.editionGrid.clear();
            this.editionGrid.resize(1, 1);
            this.editionGrid.setWidget(0, 0, display);
        }
        this.setVisible(true);
    }

    public FBValidationItem getCurrentValidation() {
        return this.currentValidation;
    }
}

