/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.HiddenRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.resources.FormBuilderResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class HiddenFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private Hidden hidden = new Hidden();
    private String id;
    private String name;
    private String value;

    public HiddenFormItem() {
        this(new ArrayList());
    }

    public HiddenFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        Grid border = new Grid(1, 1);
        border.setSize("100px", "20px");
        border.setBorderWidth(1);
        border.getCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER);
        border.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        border.setWidget(0, 0, (Widget)new Image(FormBuilderResources.INSTANCE.hiddenFieldIcon()));
        this.add((Widget)border);
        this.setSize("100px", "20px");
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", this.value);
        map.put("name", this.name);
        map.put("id", this.id);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.value = this.extractString(asPropertiesMap.get("value"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.hidden);
    }

    private void populate(Hidden hidden) {
        if (this.id != null) {
            hidden.setID(this.id);
        }
        if (this.name != null && !"".equals(this.name)) {
            hidden.setName(this.name);
        }
        if (this.value != null) {
            hidden.setValue(this.value);
        }
    }

    public FormItemRepresentation getRepresentation() {
        HiddenRepresentation rep = (HiddenRepresentation)super.getRepresentation((FormItemRepresentation)new HiddenRepresentation());
        rep.setId(this.id);
        rep.setName(this.name);
        rep.setValue(this.value);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof HiddenRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "HiddenRepresentation"));
        }
        super.populate(rep);
        HiddenRepresentation hrep = (HiddenRepresentation)rep;
        this.id = hrep.getId();
        this.name = hrep.getName();
        this.value = hrep.getValue();
        this.populate(this.hidden);
    }

    public FBFormItem cloneItem() {
        HiddenFormItem clone = new HiddenFormItem(this.getFormEffects());
        clone.id = this.id;
        clone.name = this.name;
        clone.value = this.value;
        clone.populate(clone.hidden);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        Hidden hi = new Hidden();
        this.populate(hi);
        Object input = this.getInputValue(data);
        if (input != null) {
            hi.setValue(input.toString());
        }
        if (this.getOutput() != null && this.getOutput().getName() != null && !"".equals(this.getOutput().getName())) {
            hi.setName(this.getOutput().getName());
        }
        super.populateActions(hi.getElement());
        return hi;
    }
}

