/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.I18NFormItem;
import org.jbpm.formapi.client.form.OptionsFormItem;
import org.jbpm.formapi.common.panels.ListWidget;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.SummaryRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.I18NUtils;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class SummaryFormItem
extends OptionsFormItem
implements I18NFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final ListWidget listWidget = new ListWidget();
    private final I18NUtils utils = new I18NUtils();
    private int scrollTop;
    private int scrollLeft;
    private String id;
    private String dir;
    private String cssClassName;

    public SummaryFormItem() {
        this(new ArrayList());
    }

    public SummaryFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.listWidget);
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("scrollTop", String.valueOf(this.scrollTop));
        formItemPropertiesMap.put("scrollLeft", String.valueOf(this.scrollLeft));
        formItemPropertiesMap.put("dir", this.dir);
        formItemPropertiesMap.put("id", this.id);
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        return formItemPropertiesMap;
    }

    public void saveValues(Map<String, Object> propertiesMap) {
        this.id = this.extractString(propertiesMap.get("id"));
        this.setWidth(this.extractString(propertiesMap.get("width")));
        this.setHeight(this.extractString(propertiesMap.get("height")));
        this.cssClassName = this.extractString(propertiesMap.get("cssClassName"));
        this.dir = this.extractString(propertiesMap.get("dir"));
        this.scrollTop = this.extractInt(propertiesMap.get("scrollTop"));
        this.scrollLeft = this.extractInt(propertiesMap.get("scrollLeft"));
        this.populate(this.listWidget);
    }

    private void populate(ListWidget list) {
        if (this.getWidth() != null) {
            list.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            list.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            list.setStyleName(this.cssClassName);
        }
        if (this.id != null) {
            list.setId(this.id);
        }
        if (this.dir != null) {
            list.setDir(this.dir);
        }
        if (this.scrollTop >= 0) {
            list.setScrollTop(this.scrollTop);
        }
        if (this.scrollLeft >= 0) {
            list.setScrollLeft(this.scrollLeft);
        }
    }

    public FormItemRepresentation getRepresentation() {
        SummaryRepresentation rep = (SummaryRepresentation)super.getRepresentation((FormItemRepresentation)new SummaryRepresentation());
        rep.setCssClassName(this.cssClassName);
        rep.setDir(this.dir);
        rep.setId(this.id);
        rep.setScrollLeft(this.scrollLeft);
        rep.setScrollTop(this.scrollTop);
        rep.setI18n(this.getI18nMap());
        rep.setItems(this.listWidget.getItems());
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof SummaryRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "SummaryRepresentation"));
        }
        super.populate(rep);
        SummaryRepresentation srep = (SummaryRepresentation)rep;
        this.cssClassName = srep.getCssClassName();
        this.dir = srep.getDir();
        if (srep.getWidth() != null && !"".equals(srep.getWidth())) {
            this.setWidth(srep.getWidth());
        }
        if (srep.getHeight() != null && !"".equals(srep.getHeight())) {
            this.setHeight(srep.getHeight());
        }
        this.utils.saveI18nMap(srep.getI18n());
        this.id = srep.getId();
        this.scrollLeft = srep.getScrollLeft();
        this.scrollTop = srep.getScrollTop();
        this.populate(this.listWidget);
    }

    public Widget cloneDisplay(Map<String, Object> formData) {
        ListWidget lw = new ListWidget();
        this.populate(lw);
        Object value = this.getInputValue(formData);
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] arr;
                for (Object obj : arr = (Object[])value) {
                    lw.addItem(String.valueOf(obj));
                }
            } else if (value instanceof Collection) {
                Collection coll = (Collection)value;
                for (Object obj : coll) {
                    lw.addItem(String.valueOf(obj));
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                for (Object obj : map.values()) {
                    lw.addItem(String.valueOf(obj));
                }
            }
        } else {
            String locale = (String)formData.get("org.jbpm.formbuilder.server.render.Renderer.BASE_LOCALE");
            if (locale == null) {
                for (String item : this.listWidget.getItems()) {
                    lw.addItem(item);
                }
            } else {
                String[] items;
                String i18nText = this.getI18n(locale);
                if (i18nText != null && !"".equals(i18nText) && (items = i18nText.split(",")) != null) {
                    for (String item : items) {
                        lw.addItem(item);
                    }
                }
            }
        }
        super.populateActions(lw.getElement());
        return lw;
    }

    public FBFormItem cloneItem() {
        SummaryFormItem clone = (SummaryFormItem)super.cloneItem((FBFormItem)new SummaryFormItem());
        clone.cssClassName = this.cssClassName;
        clone.id = this.id;
        clone.dir = this.dir;
        clone.scrollLeft = this.scrollLeft;
        clone.scrollTop = this.scrollTop;
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.populate(clone.listWidget);
        clone.saveI18nMap(this.getI18nMap());
        clone.setFormat(this.getFormat());
        return clone;
    }

    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    public I18NFormItem.Format getFormat() {
        return this.utils.getFormat();
    }

    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    public void saveI18nMap(Map<String, String> i18nMap) {
        this.utils.saveI18nMap(i18nMap);
    }

    public void setFormat(I18NFormItem.Format format) {
        this.utils.setFormat(format);
    }

    public void addItem(String label, String value) {
        this.listWidget.addItem(label);
    }

    public void deleteItem(String label) {
        this.listWidget.removeItem(label);
    }

    public Map<String, String> getItems() {
        HashMap<String, String> items = new HashMap<String, String>();
        for (String label : this.listWidget.getItems()) {
            items.put(label, label);
        }
        return items;
    }
}

