/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.TextFieldRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class TextFieldFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final TextBox textBox = new TextBox();
    private String defaultContent = null;
    private String name = null;
    private String id = null;
    private String title = null;
    private Integer maxlength = null;

    public TextFieldFormItem() {
        this(new ArrayList());
    }

    public TextFieldFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.textBox);
        this.setWidth("150px");
        this.setHeight("25px");
        this.textBox.setWidth(this.getWidth());
        this.textBox.setHeight(this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputDefaultContent", this.defaultContent);
        map.put("name", this.name);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("maxlength", this.maxlength);
        map.put("title", this.title);
        map.put("id", this.id);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.defaultContent = this.extractString(asPropertiesMap.get("inputDefaultContent"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.maxlength = this.extractInt(asPropertiesMap.get("maxlength"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.textBox);
    }

    private void populate(TextBox textBox) {
        if (this.defaultContent != null) {
            textBox.setValue((Object)this.defaultContent);
        }
        if (this.name != null) {
            textBox.setName(this.name);
        }
        if (this.getHeight() != null) {
            textBox.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            textBox.setWidth(this.getWidth());
        }
        if (this.title != null) {
            textBox.setTitle(this.title);
        }
        if (this.maxlength != null) {
            textBox.setMaxLength(this.maxlength.intValue());
        }
    }

    public FormItemRepresentation getRepresentation() {
        TextFieldRepresentation rep = (TextFieldRepresentation)super.getRepresentation((FormItemRepresentation)new TextFieldRepresentation());
        rep.setDefaultValue(this.defaultContent);
        rep.setName(this.name);
        rep.setId(this.id);
        rep.setMaxLength(this.maxlength);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof TextFieldRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "TextFieldRepresentation"));
        }
        super.populate(rep);
        TextFieldRepresentation trep = (TextFieldRepresentation)rep;
        this.defaultContent = trep.getDefaultValue();
        this.name = trep.getName();
        this.id = trep.getId();
        this.maxlength = trep.getMaxLength();
        if (trep.getWidth() != null && !"".equals(trep.getWidth())) {
            this.setWidth(trep.getWidth());
        }
        if (trep.getHeight() != null && !"".equals(trep.getHeight())) {
            this.setHeight(trep.getHeight());
        }
        this.populate(this.textBox);
    }

    public FBFormItem cloneItem() {
        TextFieldFormItem clone = new TextFieldFormItem(this.getFormEffects());
        clone.defaultContent = this.defaultContent;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.maxlength = this.maxlength;
        clone.name = this.name;
        clone.title = this.title;
        clone.setWidth(this.getWidth());
        clone.populate(clone.textBox);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        TextBox tb = new TextBox();
        this.populate(tb);
        Object input = this.getInputValue(data);
        if (input != null) {
            tb.setValue((Object)input.toString());
        }
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            tb.setName(this.getOutput().getName());
        }
        super.populateActions(tb.getElement());
        return tb;
    }
}

