/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import gwtupload.client.SingleUploader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.UploadWithProgressBarRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class UploadWithProgressBarFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private boolean enabled = true;
    private boolean avoidRepeatFiles = false;
    private boolean autoSubmit = false;
    private String cssClassName;
    private final SingleUploader uploader = new SingleUploader();

    public UploadWithProgressBarFormItem() {
        this(new ArrayList());
    }

    public UploadWithProgressBarFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        String uploadAction = FormBuilderGlobals.getInstance().getService().getUploadActionURL();
        this.uploader.setServletPath(uploadAction);
        this.add((Widget)this.uploader);
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        map.put("enabled", this.enabled);
        map.put("avoidRepeatFiles", this.avoidRepeatFiles);
        map.put("autoSubmit", this.autoSubmit);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.enabled = this.extractBoolean(asPropertiesMap.get("enabled"));
        this.avoidRepeatFiles = this.extractBoolean(asPropertiesMap.get("avoidRepeatFiles"));
        this.autoSubmit = this.extractBoolean(asPropertiesMap.get("autoSubmit"));
        this.populate(this.uploader);
    }

    private void populate(SingleUploader uploader) {
        if (this.getWidth() != null && !"".equals(this.getWidth())) {
            uploader.setWidth(this.getWidth());
        }
        if (this.getHeight() != null && !"".equals(this.getHeight())) {
            uploader.setHeight(this.getHeight());
        }
        uploader.setEnabled(this.enabled);
        uploader.setAvoidRepeatFiles(this.avoidRepeatFiles);
        uploader.setAutoSubmit(this.autoSubmit);
        if (this.cssClassName != null) {
            uploader.setStyleName(this.cssClassName);
        }
    }

    public FormItemRepresentation getRepresentation() {
        UploadWithProgressBarRepresentation urep = (UploadWithProgressBarRepresentation)super.getRepresentation((FormItemRepresentation)new UploadWithProgressBarRepresentation());
        urep.setAutoSubmit(this.autoSubmit);
        urep.setAvoidRepeatFiles(this.avoidRepeatFiles);
        urep.setCssClassName(this.cssClassName);
        urep.setEnabled(this.enabled);
        return urep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof UploadWithProgressBarRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "UploadWithProgressBarRepresentation"));
        }
        super.populate(rep);
        UploadWithProgressBarRepresentation urep = (UploadWithProgressBarRepresentation)rep;
        this.autoSubmit = urep.isAutoSubmit();
        this.avoidRepeatFiles = urep.isAvoidRepeatFiles();
        this.cssClassName = urep.getCssClassName();
        this.enabled = urep.isEnabled();
        this.populate(this.uploader);
    }

    public FBFormItem cloneItem() {
        UploadWithProgressBarFormItem clone = (UploadWithProgressBarFormItem)super.cloneItem((FBFormItem)new UploadWithProgressBarFormItem());
        clone.autoSubmit = this.autoSubmit;
        clone.avoidRepeatFiles = this.avoidRepeatFiles;
        clone.cssClassName = this.cssClassName;
        clone.enabled = this.enabled;
        clone.populate(clone.uploader);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> formData) {
        SingleUploader uploader = new SingleUploader();
        uploader.setServletPath("upload");
        this.populate(uploader);
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            uploader.getFileInput().setName(this.getOutput().getName());
        }
        super.populateActions(((FileUpload)uploader.getFileInput()).getElement());
        return uploader;
    }
}

