/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.layout;

import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.shared.api.InputData;
import org.jbpm.formapi.shared.api.OutputData;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.bus.FormDataPopulatedEvent;
import org.jbpm.formbuilder.client.bus.GetFormRepresentationEvent;
import org.jbpm.formbuilder.client.bus.RegisterLayoutEvent;
import org.jbpm.formbuilder.client.bus.ui.FormSavedEvent;
import org.jbpm.formbuilder.client.bus.ui.GetFormDisplayEvent;
import org.jbpm.formbuilder.client.bus.ui.TaskSelectedEvent;
import org.jbpm.formbuilder.client.bus.ui.UpdateFormViewEvent;
import org.jbpm.formbuilder.client.layout.LayoutView;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutPresenter {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final LayoutView layoutView;

    public LayoutPresenter(LayoutView view) {
        PickupDragController dragController = CommonGlobals.getInstance().getDragController();
        this.layoutView = view;
        this.layoutView.startDropController(dragController, (IsWidget)this.layoutView);
        this.bus.addHandler(RegisterLayoutEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(GetFormRepresentationEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(GetFormDisplayEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(FormDataPopulatedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(TaskSelectedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(FormSavedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(UpdateFormViewEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Map<String, InputData> toInputs(List<TaskPropertyRef> inputs) {
        HashMap<String, InputData> retval = new HashMap<String, InputData>();
        if (inputs != null) {
            for (TaskPropertyRef ref : inputs) {
                InputData input = new InputData();
                input.setName(ref.getName());
                input.setValue(ref.getSourceExpresion());
                retval.put(ref.getName(), input);
            }
        }
        return retval;
    }

    private Map<String, OutputData> toOutputs(List<TaskPropertyRef> outputs) {
        HashMap<String, OutputData> retval = new HashMap<String, OutputData>();
        if (outputs != null) {
            for (TaskPropertyRef ref : outputs) {
                OutputData output = new OutputData();
                output.setName(ref.getName());
                output.setValue(ref.getSourceExpresion());
                retval.put(ref.getName(), output);
            }
        }
        return retval;
    }

    private void populateFormData(String action, String processId, String taskId, String name, String method, String enctype) {
        if (action != null && !"".equals(action)) {
            this.layoutView.getFormDisplay().setAction(action);
        }
        if (taskId != null && !"".equals(taskId)) {
            this.layoutView.getFormDisplay().setTaskId(taskId);
        }
        if (processId != null && !"".equals(processId)) {
            this.layoutView.getFormDisplay().setProcessId(processId);
        }
        if (name != null && !"".equals(name)) {
            this.layoutView.getFormDisplay().setName(name);
        }
        this.layoutView.getFormDisplay().setMethod(method);
        this.layoutView.getFormDisplay().setEnctype(enctype);
    }

    static /* synthetic */ LayoutView access$000(LayoutPresenter x0) {
        return x0.layoutView;
    }

    static /* synthetic */ EventBus access$100(LayoutPresenter x0) {
        return x0.bus;
    }

    static /* synthetic */ void access$200(LayoutPresenter x0, String x1, String x2, String x3, String x4, String x5, String x6) {
        x0.populateFormData(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ Map access$300(LayoutPresenter x0, List x1) {
        return x0.toInputs(x1);
    }

    static /* synthetic */ Map access$400(LayoutPresenter x0, List x1) {
        return x0.toOutputs(x1);
    }

    static /* synthetic */ I18NConstants access$500(LayoutPresenter x0) {
        return x0.i18n;
    }
}

