/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.validation;

import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.List;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.validation.FBValidationItem;
import org.jbpm.formapi.shared.api.FBValidation;
import org.jbpm.formapi.shared.api.validation.XORValidation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.validation.OtherValidationsAware;
import org.jbpm.formbuilder.client.validation.SubValidationsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Reflectable
public class XORValidationItem
extends FBValidationItem
implements OtherValidationsAware {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private SubValidationsList subValidations = null;

    public String getName() {
        return this.i18n.XORValidationName();
    }

    public void setExistingValidations(List<FBValidationItem> existingValidations) {
        this.subValidations = new SubValidationsList("XOR", existingValidations);
    }

    public FBValidation createValidation() {
        XORValidation validation = (XORValidation)this.getRepresentation((FBValidation)new XORValidation());
        if (this.subValidations != null && this.subValidations.getItems() != null) {
            for (FBValidationItem subValidationItem : this.subValidations.getItems()) {
                FBValidation subValidation = subValidationItem.createValidation();
                validation.addValidation(subValidation);
            }
        }
        return validation;
    }

    public Widget createDisplay() {
        return this.subValidations;
    }

    public FBValidationItem cloneItem() {
        XORValidationItem clone = new XORValidationItem();
        for (FBValidationItem item : this.subValidations.getItems()) {
            clone.subValidations.addItem(item.cloneItem());
        }
        return clone;
    }

    public void populate(FBValidation validation) throws FormBuilderException {
        if (!(validation instanceof XORValidation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(validation.getClass().getName(), "XORValidation"));
        }
        this.subValidations.clearItems();
        XORValidation xor = (XORValidation)validation;
        List subVals = xor.getValidations();
        for (FBValidation subVal : subVals) {
            FBValidationItem item = XORValidationItem.createValidation((FBValidation)subVal);
            this.subValidations.addItem(item);
        }
    }
}

