/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.visualization.client.AbstractDataTable;
import com.google.gwt.visualization.client.AbstractDrawOptions;
import com.google.gwt.visualization.client.DataTable;
import com.google.gwt.visualization.client.visualizations.LineChart;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.LineGraphRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class LineGraphFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private LineChart chart = new LineChart((AbstractDataTable)DataTable.create(), LineChart.Options.create());
    private List<List<String>> dataTableRep = new ArrayList();
    private List<Map.Entry<String, String>> dataStructRep = new ArrayList();
    private String graphTitle;
    private String graphXTitle;
    private String graphYTitle;

    public LineGraphFormItem() {
        this(new ArrayList());
    }

    public LineGraphFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.setSize("200px", "150px");
        this.chart.setSize("200px", "150px");
        this.add((Widget)this.chart);
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        map.put("graphTitle", this.graphTitle);
        map.put("graphXTitle", this.graphXTitle);
        map.put("graphYTitle", this.graphYTitle);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        HashMap map = new HashMap();
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.graphTitle = this.extractString(map.get("graphTitle"));
        this.graphXTitle = this.extractString(map.get("graphXTitle"));
        this.graphYTitle = this.extractString(map.get("graphYTitle"));
        this.populate(this.chart);
    }

    private int getIntValue(Object obj) {
        return Integer.valueOf(obj.toString());
    }

    private void populate(LineChart chart) {
        LineChart.Options options = LineChart.Options.create();
        options.setWidth(this.getOffsetWidth());
        options.setHeight(this.getOffsetHeight());
        options.setTitle(this.graphTitle);
        options.setTitleX(this.graphXTitle);
        options.setTitleY(this.graphYTitle);
        DataTable dataTable = DataTable.create();
        if (this.dataStructRep != null) {
            for (Map.Entry col : this.dataStructRep) {
                dataTable.addColumn(AbstractDataTable.ColumnType.valueOf((String)((String)col.getValue())), (String)col.getKey());
            }
        }
        if (this.dataTableRep != null) {
            for (List row : this.dataTableRep) {
                dataTable.setValue(this.getIntValue(row.get(0)), this.getIntValue(row.get(1)), (String)row.get(2));
            }
        }
        chart.draw((AbstractDataTable)dataTable, (AbstractDrawOptions)options);
    }

    public FormItemRepresentation getRepresentation() {
        LineGraphRepresentation rep = (LineGraphRepresentation)super.getRepresentation((FormItemRepresentation)new LineGraphRepresentation());
        rep.setDataStructure(new ArrayList(this.dataStructRep));
        rep.setDataTable(new ArrayList(this.dataTableRep));
        rep.setGraphTitle(this.graphTitle);
        rep.setGraphXTitle(this.graphXTitle);
        rep.setGraphYTitle(this.graphYTitle);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof LineGraphRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "LineGraphRepresentation"));
        }
        super.populate(rep);
        LineGraphRepresentation grep = (LineGraphRepresentation)rep;
        this.dataStructRep = new ArrayList(grep.getDataStructure());
        this.dataTableRep = new ArrayList(grep.getDataTable());
        this.graphTitle = grep.getGraphTitle();
        this.graphXTitle = grep.getGraphXTitle();
        this.graphYTitle = grep.getGraphYTitle();
        this.populate(this.chart);
    }

    public FBFormItem cloneItem() {
        LineGraphFormItem item = (LineGraphFormItem)super.cloneItem((FBFormItem)new LineGraphFormItem(this.getFormEffects()));
        item.chart = (LineChart)this.cloneDisplay(null);
        item.dataStructRep = new ArrayList(this.dataStructRep);
        item.dataTableRep = new ArrayList(this.dataTableRep);
        item.graphTitle = this.graphTitle;
        item.graphXTitle = this.graphXTitle;
        item.graphYTitle = this.graphYTitle;
        return item;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        LineChart chart = new LineChart();
        this.populate(chart);
        if (this.getInput() != null && this.getInput().getName() != null) {
            DataTable dataTable = DataTable.create();
            Object myData = data.get(this.getInput().getName());
            this.populateInput(dataTable, myData);
            chart.draw((AbstractDataTable)dataTable);
        }
        super.populateActions(chart.getElement());
        return chart;
    }

    private void populateInput(DataTable dataTable, Object myData) {
        block4: {
            block5: {
                block3: {
                    if (!myData.getClass().isArray()) break block3;
                    Object[] myDataArray = (Object[])myData;
                    int index = 0;
                    for (Object item : myDataArray) {
                        this.setRowDataFromInput(dataTable, index, item);
                        ++index;
                    }
                    break block4;
                }
                if (!(myData instanceof Collection)) break block5;
                Collection myDataCol = (Collection)myData;
                int index = 0;
                for (Object item : myDataCol) {
                    this.setRowDataFromInput(dataTable, index, item);
                    ++index;
                }
                break block4;
            }
            if (!(myData instanceof Map)) break block4;
            Map myDataMap = (Map)myData;
            int index = 0;
            for (Object item : myDataMap.values()) {
                this.setRowDataFromInput(dataTable, index, item);
                ++index;
            }
        }
    }

    private void setRowDataFromInput(DataTable dataTable, int index, Object item) {
        if (item.getClass().isArray()) {
            Object[] subObjArray = (Object[])item;
            int columnIndex = 0;
            for (Object subObj : subObjArray) {
                String value = subObj.toString();
                dataTable.setCell(index, columnIndex, value, value, null);
                ++columnIndex;
            }
        } else if (item instanceof Collection) {
            Collection subObjCol = (Collection)item;
            int columnIndex = 0;
            for (Object subObj : subObjCol) {
                String value = subObj.toString();
                dataTable.setCell(index, columnIndex, value, value, null);
                ++columnIndex;
            }
        } else if (item instanceof Map) {
            Map subObjMap = (Map)item;
            int columnIndex = 0;
            for (Object subObj : subObjMap.values()) {
                String value = subObj.toString();
                dataTable.setCell(index, columnIndex, value, value, null);
                ++columnIndex;
            }
        } else {
            String value = item.toString();
            dataTable.setCell(index, 0, value, value, null);
        }
    }
}

