/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.MenuPanelRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class MenuLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final HorizontalPanel panel = new HorizontalPanel();
    private String type;
    private String cssClassName;
    private String id;
    private String dir;

    public MenuLayoutFormItem() {
        this(new ArrayList());
    }

    public MenuLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.panel.setBorderWidth(0);
        this.setSize("200px", "90px");
        this.panel.setSize(this.getWidth(), this.getHeight());
        this.add((Widget)this.panel);
    }

    public void replacePhantom(FBFormItem item) {
        PhantomPanel phantom = null;
        for (Widget widget : this.panel) {
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom != null) {
            int index = this.panel.getWidgetIndex(phantom);
            super.insert(index, item);
            this.remove((Widget)phantom);
        } else {
            this.add(item);
        }
    }

    public boolean add(FBFormItem item) {
        this.panel.add((Widget)item);
        return super.add(item);
    }

    public void add(PhantomPanel phantom, int x, int y) {
        for (int index = 0; index < this.panel.getWidgetCount(); ++index) {
            Widget item = this.panel.getWidget(index);
            int left = item.getAbsoluteLeft();
            int right = left + item.getOffsetWidth();
            int top = item.getAbsoluteTop();
            int bottom = top + item.getOffsetHeight();
            if (x <= left || x >= right || y <= top || y >= bottom) continue;
            this.panel.insert((Widget)phantom, index);
            break;
        }
    }

    public HasWidgets getPanel() {
        return this.panel;
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        formItemPropertiesMap.put("dir", this.dir);
        formItemPropertiesMap.put("id", this.id);
        formItemPropertiesMap.put("type", this.type);
        return formItemPropertiesMap;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
        this.dir = this.extractString(asPropertiesMap.get("dir"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.type = this.extractString(asPropertiesMap.get("type"));
        this.populate(this.panel);
    }

    private void populate(HorizontalPanel panel) {
        if (this.getHeight() != null) {
            panel.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            panel.setStyleName(this.cssClassName);
        }
        if (this.dir != null) {
            panel.getElement().setDir(this.dir);
        }
        if (this.id != null) {
            panel.getElement().setId(this.id);
        }
        if (this.getWidth() != null) {
            panel.setWidth(this.getWidth());
        }
        if (this.type != null) {
            panel.setStyleName(this.type + " " + panel.getStyleName());
        }
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof MenuPanelRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "MenuPanelRepresentation"));
        }
        super.populate(rep);
        MenuPanelRepresentation mrep = (MenuPanelRepresentation)rep;
        this.cssClassName = mrep.getCssClassName();
        this.id = mrep.getId();
        this.dir = mrep.getDir();
        this.type = mrep.getType();
        if (mrep.getWidth() != null && !"".equals(mrep.getWidth())) {
            this.setWidth(mrep.getWidth());
        }
        if (mrep.getHeight() != null && !"".equals(mrep.getHeight())) {
            this.setHeight(mrep.getHeight());
        }
        this.populate(this.panel);
        if (mrep.getItems() != null) {
            for (FormItemRepresentation item : mrep.getItems()) {
                this.add(LayoutFormItem.createItem((FormItemRepresentation)item));
            }
        }
    }

    public FormItemRepresentation getRepresentation() {
        MenuPanelRepresentation rep = (MenuPanelRepresentation)super.getRepresentation((FormItemRepresentation)new MenuPanelRepresentation());
        rep.setCssClassName(this.cssClassName);
        rep.setId(this.id);
        rep.setHeight(this.getHeight());
        rep.setWidth(this.getWidth());
        rep.setDir(this.dir);
        rep.setType(this.type);
        ArrayList<FormItemRepresentation> items = new ArrayList<FormItemRepresentation>();
        for (FBFormItem item : this.getItems()) {
            items.add(item.getRepresentation());
        }
        rep.setItems(items);
        return rep;
    }

    public FBFormItem cloneItem() {
        MenuLayoutFormItem clone = (MenuLayoutFormItem)super.cloneItem((FBFormItem)new MenuLayoutFormItem(this.getFormEffects()));
        clone.cssClassName = this.cssClassName;
        clone.id = this.id;
        clone.dir = this.dir;
        clone.type = this.type;
        clone.populate(clone.panel);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> formData) {
        HorizontalPanel hp = new HorizontalPanel();
        hp.setBorderWidth(0);
        this.populate(hp);
        super.populateActions(hp.getElement());
        for (FBFormItem item : this.getItems()) {
            hp.add(item.cloneDisplay(formData));
        }
        return hp;
    }
}

