/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.shared.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formbuilder.shared.form.AbstractBaseFormDefinitionService;
import org.jbpm.formbuilder.shared.form.FormDefinitionService;
import org.jbpm.formbuilder.shared.form.FormServiceException;
import org.jbpm.formbuilder.shared.form.MockFormDefinitionService;
import org.jbpm.formbuilder.shared.task.TaskRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockFormDefinitionService
extends AbstractBaseFormDefinitionService
implements FormDefinitionService {
    private Map<String, List<FormRepresentation>> forms = new HashMap();
    private Map<String, List<Map.Entry<String, FormItemRepresentation>>> items = new HashMap();

    public List<FormRepresentation> getForms(String pkgName) {
        return (List)this.forms.get(pkgName);
    }

    public FormRepresentation getForm(String pkgName, String formId) throws FormServiceException {
        List list = (List)this.forms.get(pkgName);
        if (list == null) {
            throw new FormServiceException();
        }
        FormRepresentation form = null;
        for (FormRepresentation f : list) {
            if (!formId.equals(f.getName())) continue;
            form = f;
            break;
        }
        return form;
    }

    public FormRepresentation getFormByUUID(String pkgName, String uuid) throws FormServiceException {
        List list = (List)this.forms.get(pkgName);
        if (list == null) {
            throw new FormServiceException();
        }
        return list.isEmpty() ? null : (FormRepresentation)list.iterator().next();
    }

    public FormItemRepresentation getFormItem(String pkgName, String formItemId) throws FormServiceException {
        List list = (List)this.items.get(pkgName);
        if (list == null) {
            throw new FormServiceException();
        }
        FormItemRepresentation item = null;
        for (Map.Entry i : list) {
            if (!formItemId.equals(i.getKey())) continue;
            item = (FormItemRepresentation)i.getValue();
            break;
        }
        return item;
    }

    public Map<String, FormItemRepresentation> getFormItems(String pkgName) {
        List list = (List)this.items.get(pkgName);
        HashMap retval = null;
        if (list != null) {
            retval = new HashMap();
            for (Map.Entry entry : list) {
                retval.put(entry.getKey(), entry.getValue());
            }
        }
        return retval;
    }

    public String saveForm(String pkgName, FormRepresentation form) {
        this.updateFormName(form);
        ArrayList<FormRepresentation> list = (ArrayList<FormRepresentation>)this.forms.get(pkgName);
        if (list == null) {
            list = new ArrayList<FormRepresentation>();
        }
        list.add(form);
        this.forms.put(pkgName, list);
        return form.getName();
    }

    public String saveFormItem(String pkgName, String formItemName, FormItemRepresentation formItem) {
        StringBuilder builder = new StringBuilder();
        this.updateItemName(formItemName, builder);
        formItemName = builder.toString();
        ArrayList<1> list = (ArrayList<1>)this.items.get(pkgName);
        if (list == null) {
            list = new ArrayList<1>();
        }
        String itemName = formItemName;
        list.add(new /* Unavailable Anonymous Inner Class!! */);
        this.items.put(pkgName, list);
        return itemName;
    }

    public void deleteForm(String pkgName, String formId) {
        List list = (List)this.forms.get(pkgName);
        if (list != null) {
            FormRepresentation toRemove = null;
            if (formId != null) {
                for (FormRepresentation form : list) {
                    if (!formId.equals(form.getName())) continue;
                    toRemove = form;
                    break;
                }
            }
            if (toRemove != null) {
                list.remove(toRemove);
            }
            this.forms.put(pkgName, list);
        }
    }

    public void deleteFormItem(String pkgName, String formItemId) {
        List list = (List)this.items.get(pkgName);
        if (list != null) {
            Map.Entry toRemove = null;
            for (Map.Entry item : list) {
                if (!formItemId.equals(item.getKey())) continue;
                toRemove = item;
                break;
            }
            if (toRemove != null) {
                list.remove(toRemove);
            }
            this.items.put(pkgName, list);
        }
    }

    public FormRepresentation getAssociatedForm(String pkgName, TaskRef task) throws FormServiceException {
        List forms = (List)this.forms.get(pkgName);
        FormRepresentation retval = null;
        for (FormRepresentation form : forms) {
            if (form.getTaskId() == null || !form.getTaskId().equals(task.getTaskId())) continue;
            retval = form;
            break;
        }
        return retval;
    }

    public void saveTemplate(String packageName, String templateName, String content) throws FormServiceException {
    }
}

