/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.CheckBoxRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class CheckBoxFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private CheckBox checkBox = new CheckBox();
    private String formValue;
    private Boolean checked;
    private String name;
    private String id;

    public CheckBoxFormItem() {
        this(new ArrayList());
    }

    public CheckBoxFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.checkBox);
        this.setWidth("15px");
        this.setHeight("15px");
        this.checkBox.setSize(this.getWidth(), this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formValue", this.formValue);
        map.put("checked", this.checked);
        map.put("name", this.name);
        map.put("id", this.id);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.formValue = this.extractString(asPropertiesMap.get("formValue"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.checked = this.extractBoolean(asPropertiesMap.get("checked"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.populate(this.checkBox);
    }

    private void populate(CheckBox checkBox) {
        if (this.formValue != null) {
            checkBox.setFormValue(this.formValue);
        }
        if (this.name != null) {
            checkBox.setName(this.name);
        }
        if (this.checked != null) {
            checkBox.setValue(this.checked);
        }
        if (this.getWidth() != null) {
            checkBox.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            checkBox.setHeight(this.getHeight());
        }
    }

    public FormItemRepresentation getRepresentation() {
        CheckBoxRepresentation rep = (CheckBoxRepresentation)super.getRepresentation((FormItemRepresentation)new CheckBoxRepresentation());
        rep.setFormValue(this.formValue);
        rep.setName(this.name);
        rep.setId(this.id);
        rep.setChecked(this.checked);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof CheckBoxRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "CheckBoxRepresentation"));
        }
        super.populate(rep);
        CheckBoxRepresentation crep = (CheckBoxRepresentation)rep;
        this.formValue = crep.getFormValue();
        this.name = crep.getName();
        this.id = crep.getId();
        this.checked = crep.getChecked();
        this.populate(this.checkBox);
    }

    public FBFormItem cloneItem() {
        CheckBoxFormItem clone = new CheckBoxFormItem(this.getFormEffects());
        clone.setWidth(this.getWidth());
        clone.setHeight(this.getHeight());
        clone.checked = this.checked;
        clone.formValue = this.formValue;
        clone.id = this.id;
        clone.name = this.name;
        clone.populate(clone.checkBox);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        CheckBox cb = new CheckBox();
        this.populate(cb);
        Object input = this.getInputValue(data);
        if (input != null) {
            cb.setValue(Boolean.valueOf(input.toString()));
        }
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            cb.setName(this.getOutput().getName());
        }
        super.populateActions(cb.getElement());
        return cb;
    }
}

