/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.ConditionalBlockRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Reflectable
public class ConditionalBlockFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private Grid display = new /* Unavailable Anonymous Inner Class!! */;
    private FBFormItem ifBlock = null;
    private FBFormItem elseBlock = null;
    private String conditionScript = "true";

    public ConditionalBlockFormItem() {
        this(new ArrayList());
    }

    public ConditionalBlockFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.display.setBorderWidth(1);
        this.display.setStyleName("conditionalBlockBorder");
        this.display.setSize("100%", "50px");
        this.add((Widget)this.display);
        this.setSize("100%", "50px");
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conditionScript", this.conditionScript);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.conditionScript = this.extractString(asPropertiesMap.get("conditionScript"));
    }

    public FormItemRepresentation getRepresentation() {
        ConditionalBlockRepresentation rep = (ConditionalBlockRepresentation)super.getRepresentation((FormItemRepresentation)new ConditionalBlockRepresentation());
        rep.setCondition(this.conditionScript);
        rep.setIfBlock(this.ifBlock == null ? null : this.ifBlock.getRepresentation());
        rep.setElseBlock(this.elseBlock == null ? null : this.elseBlock.getRepresentation());
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof ConditionalBlockRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "ConditionalBlockRepresentation"));
        }
        super.populate(rep);
        ConditionalBlockRepresentation srep = (ConditionalBlockRepresentation)rep;
        this.conditionScript = srep.getCondition();
        FormItemRepresentation ifRep = srep.getIfBlock();
        this.ifBlock = ifRep == null ? null : ConditionalBlockFormItem.createItem((FormItemRepresentation)ifRep);
        FormItemRepresentation elseRep = srep.getElseBlock();
        this.elseBlock = elseRep == null ? null : ConditionalBlockFormItem.createItem((FormItemRepresentation)elseRep);
    }

    public FBFormItem cloneItem() {
        ConditionalBlockFormItem item = new ConditionalBlockFormItem(super.getFormEffects());
        item.conditionScript = this.conditionScript;
        item.elseBlock = this.elseBlock == null ? null : this.elseBlock.cloneItem();
        item.ifBlock = this.ifBlock == null ? null : this.ifBlock.cloneItem();
        return item;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        Widget actualBlock;
        Widget elseBlock = this.elseBlock == null ? null : this.elseBlock.cloneDisplay(data);
        Widget ifBlock = this.ifBlock == null ? null : this.ifBlock.cloneDisplay(data);
        String condition = this.conditionScript;
        boolean result = this.eval0(condition);
        Widget widget = actualBlock = result ? ifBlock : elseBlock;
        if (actualBlock != null) {
            super.populateActions(actualBlock.getElement());
        }
        return actualBlock;
    }

    private native boolean eval0(String var1);

    public HasWidgets getPanel() {
        return this.display;
    }

    public void add(PhantomPanel phantom, int x, int y) {
        Element elseDisplay;
        Element ifDisplay = this.display.getCellFormatter().getElement(0, 0);
        if (x > ifDisplay.getAbsoluteLeft() && x < ifDisplay.getAbsoluteRight() && y > ifDisplay.getAbsoluteTop() && y < ifDisplay.getAbsoluteBottom()) {
            this.display.setWidget(0, 0, (Widget)phantom);
        }
        if (x > (elseDisplay = this.display.getCellFormatter().getElement(1, 0)).getAbsoluteLeft() && x < elseDisplay.getAbsoluteRight() && y > elseDisplay.getAbsoluteTop() && y < elseDisplay.getAbsoluteBottom()) {
            this.display.setWidget(1, 0, (Widget)phantom);
        }
    }

    public boolean add(FBFormItem item) {
        boolean retval = false;
        if (this.ifBlock != null && this.elseBlock != null) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.ConditionalBlockFull()));
        } else if (this.ifBlock == null && this.elseBlock == null) {
            this.ifBlock = item;
            this.display.setWidget(0, 0, (Widget)item);
            retval = true;
        } else if (this.ifBlock != null && this.elseBlock == null) {
            this.elseBlock = item;
            this.display.setWidget(1, 0, (Widget)item);
            retval = true;
        } else if (this.ifBlock == null && this.elseBlock != null) {
            this.ifBlock = item;
            this.display.setWidget(1, 0, (Widget)item);
            retval = true;
        }
        return retval;
    }

    public void replacePhantom(FBFormItem item) {
        if (this.display.getWidget(0, 0) != null && this.display.getWidget(0, 0) instanceof PhantomPanel) {
            this.ifBlock = item;
            this.display.setWidget(0, 0, (Widget)item);
        } else if (this.display.getWidget(1, 0) != null && this.display.getWidget(1, 0) instanceof PhantomPanel) {
            this.elseBlock = item;
            this.display.setWidget(1, 0, (Widget)item);
        }
    }

    static /* synthetic */ FBFormItem access$000(ConditionalBlockFormItem x0) {
        return x0.ifBlock;
    }

    static /* synthetic */ FBFormItem access$002(ConditionalBlockFormItem x0, FBFormItem x1) {
        x0.ifBlock = x1;
        return x0.ifBlock;
    }

    static /* synthetic */ FBFormItem access$100(ConditionalBlockFormItem x0) {
        return x0.elseBlock;
    }

    static /* synthetic */ FBFormItem access$102(ConditionalBlockFormItem x0, FBFormItem x1) {
        x0.elseBlock = x1;
        return x0.elseBlock;
    }
}

