/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ConfigurationUtils {
    private static final String UNDEFINED_HOSTNAME = "undefined.host";
    private String webServiceHost;
    private int webServicePort;
    private MBeanServer mbeanServer;

    public String getWebServiceHost() {
        return this.webServiceHost;
    }

    public void setWebServiceHost(String host) throws UnknownHostException {
        if (host == null || host.trim().length() == 0) {
            System.out.println("Using undefined host: undefined.host");
            host = UNDEFINED_HOSTNAME;
        }
        if ("0.0.0.0".equals(host)) {
            InetAddress localHost = InetAddress.getLocalHost();
            System.out.println("Using local host: " + localHost.getHostName());
            host = localHost.getHostName();
        }
        this.webServiceHost = host;
    }

    public int getWebServicePort() {
        int localPort;
        if (this.webServicePort <= 0) {
            this.webServicePort = this.getConnectorPort("HTTP/1.1", false);
        }
        if ((localPort = this.webServicePort) <= 0) {
            System.out.println("Unable to calculate 'WebServicePort', using default '8080'");
            localPort = 8080;
        }
        return localPort;
    }

    private int getConnectorPort(String protocol, boolean secure) {
        int port = -1;
        try {
            ObjectName connectors = new ObjectName("jboss.web:type=Connector,*");
            Set<ObjectName> connectorNames = this.getMbeanServer().queryNames(connectors, null);
            Iterator<ObjectName> i$ = connectorNames.iterator();
            while (i$.hasNext()) {
                ObjectName current;
                ObjectName currentName = current = i$.next();
                try {
                    int connectorPort = (Integer)this.getMbeanServer().getAttribute(currentName, "port");
                    boolean connectorSecure = (Boolean)this.getMbeanServer().getAttribute(currentName, "secure");
                    String connectorProtocol = (String)this.getMbeanServer().getAttribute(currentName, "protocol");
                    if (!protocol.equals(connectorProtocol) || secure != connectorSecure) continue;
                    if (port > -1) {
                        System.out.println("Found multiple connectors for protocol='" + protocol + "' and secure='" + secure + "', using first port found '" + port + "'");
                        continue;
                    }
                    port = connectorPort;
                }
                catch (AttributeNotFoundException ignored) {}
            }
            return port;
        }
        catch (JMException e) {
            return -1;
        }
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }
}

