/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import org.drools.SystemEventListenerFactory;
import org.jboss.bpm.console.server.plugin.FormAuthorityRef;
import org.jbpm.integration.console.forms.AbstractFormDispatcher;
import org.jbpm.task.Content;
import org.jbpm.task.I18NText;
import org.jbpm.task.Task;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.mina.BaseMinaHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;

public class TaskFormDispatcher
extends AbstractFormDispatcher {
    private TaskClient client;

    public void connect() {
        if (this.client == null) {
            int port;
            String ipAddress;
            Properties properties = new Properties();
            try {
                properties.load(AbstractFormDispatcher.class.getResourceAsStream("/jbpm.console.properties"));
                ipAddress = properties.getProperty("jbpm.console.task.service.host");
                port = new Integer(properties.getProperty("jbpm.console.task.service.port"));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load jbpm.console.properties", e);
            }
            this.client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("org.drools.process.workitem.wsht.WSHumanTaskHandler", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
            boolean connected = this.client.connect(ipAddress, port);
            if (!connected) {
                throw new IllegalArgumentException("Could not connect task client");
            }
        }
    }

    public DataHandler provideForm(FormAuthorityRef ref) {
        this.connect();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(new Long(ref.getReferenceId()).longValue(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        Object input = null;
        long contentId = task.getTaskData().getDocumentContentId();
        if (contentId != -1L) {
            BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
            this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
            Content content = getContentResponseHandler.getContent();
            ByteArrayInputStream bis = new ByteArrayInputStream(content.getContent());
            try {
                ObjectInputStream in = new ObjectInputStream(bis);
                input = in.readObject();
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        String name = null;
        List names = task.getNames();
        for (I18NText text : names) {
            if (!"en-UK".equals(text.getLanguage())) continue;
            name = text.getText();
        }
        InputStream template = this.getTemplate(name);
        if (template == null) {
            template = TaskFormDispatcher.class.getResourceAsStream("/DefaultTask.ftl");
        }
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("task", task);
        renderContext.put("content", input);
        if (input instanceof Map) {
            Map map = (Map)input;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                renderContext.put((String)entry.getKey(), entry.getValue());
            }
        }
        return this.processTemplate(name, template, renderContext);
    }
}

