/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import org.jboss.bpm.console.server.plugin.FormAuthorityRef;
import org.jbpm.integration.console.TaskClientFactory;
import org.jbpm.integration.console.forms.AbstractFormDispatcher;
import org.jbpm.task.Content;
import org.jbpm.task.I18NText;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;

public class TaskFormDispatcher
extends AbstractFormDispatcher {
    private static int clientCounter = 0;
    private TaskService service;
    private boolean local = false;

    public void connect() {
        if (this.service == null) {
            Properties properties = new Properties();
            try {
                properties.load(AbstractFormDispatcher.class.getResourceAsStream("/jbpm.console.properties"));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load jbpm.console.properties", e);
            }
            this.service = TaskClientFactory.newInstance((Properties)properties, (String)("org.jbpm.integration.console.forms.TaskFormDispatcher" + clientCounter));
            ++clientCounter;
        }
    }

    public DataHandler provideForm(FormAuthorityRef ref) {
        this.connect();
        Task task = this.service.getTask(new Long(ref.getReferenceId()).longValue());
        Object input = null;
        long contentId = task.getTaskData().getDocumentContentId();
        if (contentId != -1L) {
            Content content = null;
            content = this.service.getContent(contentId);
            ByteArrayInputStream bis = new ByteArrayInputStream(content.getContent());
            try {
                ObjectInputStream in = new ObjectInputStream(bis);
                input = in.readObject();
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        String name = null;
        List names = task.getNames();
        for (I18NText text : names) {
            if (!"en-UK".equals(text.getLanguage())) continue;
            name = text.getText();
        }
        InputStream template = this.getTemplate(name);
        if (template == null) {
            template = TaskFormDispatcher.class.getResourceAsStream("/DefaultTask.ftl");
        }
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("task", task);
        renderContext.put("content", input);
        if (input instanceof Map) {
            Map map = (Map)input;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                renderContext.put((String)entry.getKey(), entry.getValue());
            }
        }
        return this.processTemplate(name, template, renderContext);
    }
}

