/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.jboss.bpm.console.server.plugin.FormAuthorityRef;
import org.jboss.bpm.console.server.plugin.FormDispatcherPlugin;
import org.jbpm.integration.console.shared.GuvnorConnectionUtils;
import org.jbpm.integration.console.shared.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFormDispatcher
implements FormDispatcherPlugin {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFormDispatcher.class);

    public URL getDispatchUrl(FormAuthorityRef ref) {
        StringBuffer sb = new StringBuffer();
        Properties properties = PropertyLoader.getJbpmConsoleProperties();
        sb.append("http://");
        sb.append(properties.getProperty("jbpm.console.server.host", "localhost").trim());
        sb.append(":").append(new Integer(properties.getProperty("jbpm.console.server.port", "8080").trim()));
        sb.append("/" + properties.getProperty("jbpm.console.server.context", "gwt-console-server") + "/rs/form/" + this.getType(ref) + "/");
        sb.append(ref.getReferenceId());
        sb.append("/render");
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to resolve form dispatch url", e);
        }
    }

    protected String getType(FormAuthorityRef ref) {
        FormAuthorityRef.Type type = ref.getType();
        if (type.equals((Object)FormAuthorityRef.Type.TASK)) {
            return "task";
        }
        if (type.equals((Object)FormAuthorityRef.Type.PROCESS)) {
            return "process";
        }
        throw new IllegalArgumentException("Unknown form authority type: " + ref.getType());
    }

    public InputStream getTemplate(String name) {
        InputStream nameTaskformResult = AbstractFormDispatcher.class.getResourceAsStream("/" + name + "-taskform.ftl");
        if (nameTaskformResult != null) {
            return nameTaskformResult;
        }
        InputStream nameResult = AbstractFormDispatcher.class.getResourceAsStream("/" + name + ".ftl");
        if (nameResult != null) {
            return nameResult;
        }
        GuvnorConnectionUtils guvnorUtils = new GuvnorConnectionUtils();
        if (guvnorUtils.guvnorExists()) {
            try {
                String templateName;
                if (guvnorUtils.templateExistsInRepo(name + "-taskform")) {
                    templateName = name + "-taskform";
                } else if (guvnorUtils.templateExistsInRepo(name)) {
                    templateName = name;
                } else {
                    return null;
                }
                return guvnorUtils.getFormTemplateFromGuvnor(templateName);
            }
            catch (Throwable t) {
                logger.error("Could not load process template from Guvnor: " + t.getMessage());
                return null;
            }
        }
        logger.warn("Could not connect to Guvnor.");
        return null;
    }

    protected DataHandler processTemplate(final String name, InputStream src, Map<String, Object> renderContext) {
        DataHandler merged = null;
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(src), cfg);
            final ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(bout);
            temp.process(renderContext, (Writer)out);
            ((Writer)out).flush();
            merged = new DataHandler(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(bout.toByteArray());
                }

                public OutputStream getOutputStream() throws IOException {
                    return bout;
                }

                public String getContentType() {
                    return "*/*";
                }

                public String getName() {
                    return name + "_DataSource";
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process form template", e);
        }
        return merged;
    }
}

