/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.graph;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.BPMN2ProcessFactory;
import org.drools.compiler.BPMN2ProcessProvider;
import org.drools.compiler.ProcessBuilderFactory;
import org.drools.compiler.ProcessBuilderFactoryService;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.definition.process.Process;
import org.drools.definition.process.WorkflowProcess;
import org.drools.io.ResourceFactory;
import org.drools.marshalling.impl.ProcessMarshallerFactory;
import org.drools.marshalling.impl.ProcessMarshallerFactoryService;
import org.drools.runtime.process.ProcessRuntimeFactory;
import org.drools.runtime.process.ProcessRuntimeFactoryService;
import org.jboss.bpm.console.client.model.ActiveNodeInfo;
import org.jboss.bpm.console.client.model.DiagramInfo;
import org.jboss.bpm.console.client.model.DiagramNodeInfo;
import org.jboss.bpm.console.server.plugin.GraphViewerPlugin;
import org.jbpm.bpmn2.BPMN2ProcessProviderImpl;
import org.jbpm.integration.console.StatefulKnowledgeSessionUtil;
import org.jbpm.integration.console.shared.GuvnorConnectionUtils;
import org.jbpm.marshalling.impl.ProcessMarshallerFactoryServiceImpl;
import org.jbpm.process.audit.JPAProcessInstanceDbLog;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.builder.ProcessBuilderFactoryServiceImpl;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphViewerPluginImpl
implements GraphViewerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(GraphViewerPluginImpl.class);
    private KnowledgeBase kbase;
    private static final int BUFFER_SIZE = 512;

    public List<ActiveNodeInfo> getActiveNodeInfo(String instanceId) {
        ProcessInstanceLog processInstance = JPAProcessInstanceDbLog.findProcessInstance((long)new Long(instanceId));
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance " + instanceId);
        }
        HashMap<String, NodeInstanceLog> nodeInstances = new HashMap<String, NodeInstanceLog>();
        for (NodeInstanceLog nodeInstance : JPAProcessInstanceDbLog.findNodeInstances((long)new Long(instanceId))) {
            if (nodeInstance.getType() == 0) {
                nodeInstances.put(nodeInstance.getNodeInstanceId(), nodeInstance);
                continue;
            }
            nodeInstances.remove(nodeInstance.getNodeInstanceId());
        }
        if (!nodeInstances.isEmpty()) {
            ArrayList<ActiveNodeInfo> result = new ArrayList<ActiveNodeInfo>();
            for (NodeInstanceLog nodeInstance : nodeInstances.values()) {
                boolean found = false;
                DiagramInfo diagramInfo = this.getDiagramInfo(processInstance.getProcessId());
                if (diagramInfo != null) {
                    for (DiagramNodeInfo nodeInfo : diagramInfo.getNodeList()) {
                        if (!nodeInfo.getName().equals("id=" + nodeInstance.getNodeId())) continue;
                        result.add(new ActiveNodeInfo(diagramInfo.getWidth(), diagramInfo.getHeight(), nodeInfo));
                        found = true;
                        break;
                    }
                } else {
                    throw new IllegalArgumentException("Could not find info for diagram for process " + processInstance.getProcessId());
                }
                if (found) continue;
                throw new IllegalArgumentException("Could not find info for node " + nodeInstance.getNodeId() + " of process " + processInstance.getProcessId());
            }
            return result;
        }
        return null;
    }

    public DiagramInfo getDiagramInfo(String processId) {
        Process process;
        if (this.kbase == null) {
            String directory;
            GuvnorConnectionUtils guvnorUtils = new GuvnorConnectionUtils();
            if (guvnorUtils.guvnorExists()) {
                try {
                    this.kbase = StatefulKnowledgeSessionUtil.getKnowledgeBaseManager().getKnowledgeBase();
                }
                catch (Throwable t) {
                    logger.error("Could not build kbase from Guvnor assets: " + t.getMessage());
                }
            } else {
                logger.warn("Could not connect to Guvnor.");
            }
            if (this.kbase == null) {
                this.kbase = KnowledgeBaseFactory.newKnowledgeBase();
            }
            if ((directory = System.getProperty("jbpm.console.directory")) == null) {
                logger.info("jbpm.console.directory property not found");
            } else {
                File file = new File(directory);
                if (!file.exists()) {
                    throw new IllegalArgumentException("Could not find " + directory);
                }
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException(directory + " is not a directory");
                }
                ProcessBuilderFactory.setProcessBuilderFactoryService((ProcessBuilderFactoryService)new ProcessBuilderFactoryServiceImpl());
                ProcessMarshallerFactory.setProcessMarshallerFactoryService((ProcessMarshallerFactoryService)new ProcessMarshallerFactoryServiceImpl());
                ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl());
                BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)new BPMN2ProcessProviderImpl());
                KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
                for (File subfile : file.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".bpmn") || name.endsWith("bpmn2");
                    }
                })) {
                    kbuilder.add(ResourceFactory.newFileResource((File)subfile), ResourceType.BPMN2);
                }
                this.kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
            }
        }
        if ((process = this.kbase.getProcess(processId)) == null) {
            return null;
        }
        DiagramInfo result = new DiagramInfo();
        result.setWidth(932);
        result.setHeight(541);
        ArrayList<DiagramNodeInfo> nodeList = new ArrayList<DiagramNodeInfo>();
        if (process instanceof WorkflowProcess) {
            this.addNodesInfo(nodeList, ((WorkflowProcess)process).getNodes(), "id=");
        }
        result.setNodeList(nodeList);
        return result;
    }

    private void addNodesInfo(List<DiagramNodeInfo> nodeInfos, Node[] nodes, String prefix) {
        for (Node node : nodes) {
            nodeInfos.add(new DiagramNodeInfo(prefix + node.getId(), ((Integer)node.getMetaData().get("x")).intValue(), ((Integer)node.getMetaData().get("y")).intValue(), ((Integer)node.getMetaData().get("width")).intValue(), ((Integer)node.getMetaData().get("height")).intValue()));
            if (!(node instanceof NodeContainer)) continue;
            this.addNodesInfo(nodeInfos, ((NodeContainer)node).getNodes(), prefix + node.getId() + ":");
        }
    }

    public byte[] getProcessImage(String processId) {
        InputStream is = GraphViewerPluginImpl.class.getResourceAsStream("/" + processId + ".png");
        if (is != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                GraphViewerPluginImpl.transfer(is, os);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read process image: " + e.getMessage());
            }
            return os.toByteArray();
        }
        GuvnorConnectionUtils guvnorUtils = new GuvnorConnectionUtils();
        if (guvnorUtils.guvnorExists()) {
            try {
                return guvnorUtils.getProcessImageFromGuvnor(processId);
            }
            catch (Throwable t) {
                logger.error("Could not get process image from Guvnor: " + t.getMessage());
            }
        } else {
            logger.warn("Could not connect to Guvnor.");
        }
        return null;
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        byte[] buffer = new byte[512];
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            total += bytesRead;
            bytesRead = in.read(buffer);
        }
        return total;
    }

    public URL getDiagramURL(String id) {
        GuvnorConnectionUtils guvnorUtils = new GuvnorConnectionUtils();
        if (guvnorUtils.guvnorExists()) {
            try {
                return new URL(guvnorUtils.getProcessImageURLFromGuvnor(id));
            }
            catch (Throwable t) {
                logger.error("Could not get diagram url from Guvnor: " + t.getMessage());
            }
        } else {
            logger.warn("Could not connect to Guvnor.");
        }
        URL result = GraphViewerPluginImpl.class.getResource("/" + id + ".png");
        if (result != null) {
            return result;
        }
        return null;
    }

    public List<ActiveNodeInfo> getNodeInfoForActivities(String processDefinitionId, List<String> activities) {
        return new ArrayList<ActiveNodeInfo>();
    }
}

