/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.CyclicBarrier;
import org.drools.core.util.IoUtils;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BPMN2DataServiceImplMultiThreadTest
extends AbstractKieServicesBaseTest {
    @Before
    public void prepare() {
        this.configureServices();
    }

    @After
    public void cleanup() {
        BPMN2DataServiceImplMultiThreadTest.cleanupSingletonSessionId();
        this.close();
    }

    @Test
    public void testBuildProcessDefinitionConcurrent() throws Exception {
        final ArrayList defs = new ArrayList();
        byte[] process1 = IoUtils.readBytesFromInputStream((InputStream)this.getClass().getResourceAsStream("/repo/processes/general/customtask.bpmn"));
        byte[] process2 = IoUtils.readBytesFromInputStream((InputStream)this.getClass().getResourceAsStream("/repo/processes/general/humanTask.bpmn"));
        final String process1Content = new String(process1, "UTF-8");
        final String process2Content = new String(process2, "UTF-8");
        final CyclicBarrier threadsFinishedBarrier = new CyclicBarrier(3);
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                ProcessDefinition def = BPMN2DataServiceImplMultiThreadTest.this.bpmn2Service.buildProcessDefinition("test", process1Content, null, true);
                defs.add(def);
                BPMN2DataServiceImplMultiThreadTest.waitForTheOtherThreads(threadsFinishedBarrier);
            }
        });
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                ProcessDefinition def = BPMN2DataServiceImplMultiThreadTest.this.bpmn2Service.buildProcessDefinition("test", process2Content, null, true);
                defs.add(def);
                BPMN2DataServiceImplMultiThreadTest.waitForTheOtherThreads(threadsFinishedBarrier);
            }
        });
        t1.start();
        t2.start();
        BPMN2DataServiceImplMultiThreadTest.waitForTheOtherThreads(threadsFinishedBarrier);
        Assert.assertEquals((long)2L, (long)defs.size());
    }
}

