/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.scanner.MavenRepository;

public class DeploymentServiceTest
extends AbstractKieServicesBaseTest {
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/signal.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        processes.add("repo/processes/general/callactivity.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, pom);
        ReleaseId releaseIdSupport = ks.newReleaseId("org.jbpm.test", "support", "1.0.0-SNAPSHOT");
        ArrayList<String> processesSupport = new ArrayList<String>();
        processesSupport.add("repo/processes/support/support.bpmn");
        InternalKieModule kJar2 = this.createKieJar(ks, releaseIdSupport, processesSupport);
        File pom2 = new File("target/kmodule2", "pom.xml");
        pom2.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom2);
            fs.write(this.getPom(releaseIdSupport, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        repository.deployArtifact(releaseIdSupport, kJar2, pom2);
        ReleaseId releaseId3 = ks.newReleaseId("org.jbpm.test", "test-module", "1.1.0-SNAPSHOT");
        processes.add("repo/rules/RuleWIthDeclaredType.drl");
        InternalKieModule kJar3 = this.createKieJar(ks, releaseId3, processes);
        File pom3 = new File("target/kmodule3", "pom.xml");
        pom3.getParentFile().mkdirs();
        try {
            FileOutputStream fs = new FileOutputStream(pom3);
            fs.write(this.getPom(releaseId3, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId3, kJar3, pom3);
    }

    @After
    public void cleanup() {
        DeploymentServiceTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testDeploymentOfProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertEquals((long)0L, (long)((DeployedUnitImpl)deployed).getDeployedClasses().size());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByFilter("custom", new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
        ProcessDefinition process = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)process);
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testDeploymentOfAllProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnitGeneral = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnitGeneral);
        this.units.add((DeploymentUnit)deploymentUnitGeneral);
        RuntimeManager managerGeneral = this.deploymentService.getRuntimeManager(deploymentUnitGeneral.getIdentifier());
        Assert.assertNotNull((Object)managerGeneral);
        KModuleDeploymentUnit deploymentUnitSupport = new KModuleDeploymentUnit("org.jbpm.test", "support", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnitSupport);
        this.units.add((DeploymentUnit)deploymentUnitSupport);
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnitGeneral.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        RuntimeManager managerSupport = this.deploymentService.getRuntimeManager(deploymentUnitSupport.getIdentifier());
        Assert.assertNotNull((Object)managerSupport);
        DeployedUnit deployedSupport = this.deploymentService.getDeployedUnit(deploymentUnitSupport.getIdentifier());
        Assert.assertNotNull((Object)deployedSupport);
        Assert.assertNotNull((Object)deployedSupport.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedSupport.getRuntimeManager());
        RuntimeEngine engine = managerGeneral.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
        RuntimeEngine engineSupport = managerSupport.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engineSupport);
        ProcessInstance supportPI = engineSupport.getKieSession().startProcess("support.process");
        Assert.assertEquals((long)1L, (long)supportPI.getState());
        List tasks = engineSupport.getTaskService().getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        engineSupport.getKieSession().abortProcessInstance(supportPI.getId());
        Assert.assertNull((Object)engineSupport.getKieSession().getProcessInstance((long)supportPI.getState()));
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicatedDeployment() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        Assert.assertFalse((boolean)this.deploymentService.isDeployed(deploymentUnit.getIdentifier()));
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        Assert.assertTrue((boolean)this.deploymentService.isDeployed(deploymentUnit.getIdentifier()));
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployedGeneral);
        Assert.assertNotNull((Object)deployedGeneral.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedGeneral.getRuntimeManager());
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
    }

    @Test
    public void testDeploymentOfMultipleVersions() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        KModuleDeploymentUnit deploymentUnit3 = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.1.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit3);
        this.units.add((DeploymentUnit)deploymentUnit3);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertEquals((long)0L, (long)((DeployedUnitImpl)deployed).getDeployedClasses().size());
        DeployedUnit deployed3 = this.deploymentService.getDeployedUnit(deploymentUnit3.getIdentifier());
        Assert.assertNotNull((Object)deployed3);
        Assert.assertNotNull((Object)deployed3.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed3.getRuntimeManager());
        Assert.assertEquals((long)1L, (long)((DeployedUnitImpl)deployed3).getDeployedClasses().size());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)10L, (long)processes.size());
        DeployedUnit deployedLatest = this.deploymentService.getDeployedUnit("org.jbpm.test:test-module:LATEST");
        Assert.assertNotNull((Object)deployedLatest);
        Assert.assertNotNull((Object)deployedLatest.getDeploymentUnit());
        Assert.assertNotNull((Object)deployedLatest.getRuntimeManager());
        Assert.assertEquals((Object)deploymentUnit3.getIdentifier(), (Object)deployedLatest.getDeploymentUnit().getIdentifier());
    }

    @Test
    public void testDeploymentOfProcessesWithActivation() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertTrue((boolean)deployed.isActive());
        Assert.assertEquals((long)0L, (long)((DeployedUnitImpl)deployed).getDeployedClasses().size());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        this.deploymentService.deactivate(deploymentUnit.getIdentifier());
        deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertFalse((boolean)deployed.isActive());
        processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)0L, (long)processes.size());
        this.deploymentService.activate(deploymentUnit.getIdentifier());
        deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertTrue((boolean)deployed.isActive());
        processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
    }

    @Test
    public void testDeploymentWithDeclaredTypeInDRL() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit3 = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.1.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit3);
        this.units.add((DeploymentUnit)deploymentUnit3);
        DeployedUnit deployed3 = this.deploymentService.getDeployedUnit(deploymentUnit3.getIdentifier());
        Assert.assertNotNull((Object)deployed3);
        Assert.assertNotNull((Object)deployed3.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed3.getRuntimeManager());
        Assert.assertEquals((long)1L, (long)((DeployedUnitImpl)deployed3).getDeployedClasses().size());
        try {
            Assert.assertNotNull(Class.forName("org.pkg1.Message", true, ((InternalRuntimeManager)deployed3.getRuntimeManager()).getEnvironment().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"Class org.pkg1.Message should be found in deployment");
        }
    }
}

