/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.store.DeploymentStore;
import org.jbpm.kie.services.impl.store.DeploymentSyncInvoker;
import org.jbpm.kie.services.impl.store.DeploymentSynchronizer;
import org.jbpm.kie.services.test.objects.CoundDownDeploymentListener;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.ListenerSupport;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.scanner.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentServiceWithSyncTest
extends AbstractKieServicesBaseTest {
    static Logger logger = LoggerFactory.getLogger(DeploymentServiceWithSyncTest.class);
    protected List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    protected DeploymentStore store;
    protected DeploymentSyncInvoker invoker;
    protected TransactionalCommandService commandService;

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    @Before
    public void prepare() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/signal.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        processes.add("repo/processes/general/callactivity.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, pom);
        ReleaseId releaseIdSupport = ks.newReleaseId("org.jbpm.test", "support", "1.0.0-SNAPSHOT");
        ArrayList<String> processesSupport = new ArrayList<String>();
        processesSupport.add("repo/processes/support/support.bpmn");
        InternalKieModule kJar2 = this.createKieJar(ks, releaseIdSupport, processesSupport);
        File pom2 = new File("target/kmodule2", "pom.xml");
        pom2.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom2);
            fs.write(this.getPom(releaseIdSupport, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repository.deployArtifact(releaseIdSupport, kJar2, pom2);
        this.configureDeploymentSync();
    }

    protected void configureDeploymentSync() {
        Assert.assertNotNull((Object)this.deploymentService);
        this.store = new DeploymentStore();
        if (this.commandService == null) {
            this.commandService = new TransactionalCommandService(this.emf);
        }
        this.store.setCommandService(this.commandService);
        DeploymentSynchronizer sync = new DeploymentSynchronizer();
        sync.setDeploymentService(this.deploymentService);
        sync.setDeploymentStore(this.store);
        this.invoker = new DeploymentSyncInvoker(sync, Long.valueOf(1L), Long.valueOf(1L), TimeUnit.SECONDS);
        this.invoker.start();
    }

    protected CoundDownDeploymentListener configureListener(int threads, boolean deploy, boolean undeploy, boolean activate, boolean deactivate) {
        CoundDownDeploymentListener countDownListener = new CoundDownDeploymentListener(threads);
        ((ListenerSupport)this.deploymentService).addListener((DeploymentEventListener)countDownListener);
        return countDownListener;
    }

    @After
    public void cleanup() {
        if (this.invoker != null) {
            this.invoker.stop();
        }
        int deleted = 0;
        logger.info("Deleted " + (deleted += ((Integer)this.commandService.execute((Command)new UpdateStringCommand("delete from  DeploymentStoreEntry dse"))).intValue()));
        DeploymentServiceWithSyncTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testDeploymentOfProcessesBySync() throws Exception {
        CoundDownDeploymentListener countDownListener = this.configureListener(1, true, false, false, false);
        Collection deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.store.enableDeploymentUnit((DeploymentUnit)unit);
        this.units.add((DeploymentUnit)unit);
        countDownListener.waitTillCompleted(10000L);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
    }

    @Test
    public void testUndeploymentOfProcessesBySync() throws Exception {
        CoundDownDeploymentListener countDownListener = this.configureListener(1, false, true, false, false);
        Collection deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)unit);
        this.units.add((DeploymentUnit)unit);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
        countDownListener.waitTillCompleted(1000L);
        this.store.disableDeploymentUnit((DeploymentUnit)unit);
        countDownListener.waitTillCompleted(10000L);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
    }

    @Test
    public void testDeactivateAndActivateOfProcessesBySync() throws Exception {
        CoundDownDeploymentListener countDownListener = this.configureListener(2, false, false, true, true);
        Collection deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)unit);
        this.units.add((DeploymentUnit)unit);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
        Assert.assertTrue((boolean)((DeployedUnit)deployed.iterator().next()).isActive());
        this.store.deactivateDeploymentUnit((DeploymentUnit)unit);
        countDownListener.waitTillCompleted(10000L);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
        Assert.assertFalse((boolean)((DeployedUnit)deployed.iterator().next()).isActive());
        this.store.activateDeploymentUnit((DeploymentUnit)unit);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted(10000L);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)1L, (long)deployed.size());
        Assert.assertTrue((boolean)((DeployedUnit)deployed.iterator().next()).isActive());
    }

    @Test
    public void testDeploymentOfProcessesBySyncWithDisabledAttribute() throws Exception {
        CoundDownDeploymentListener countDownListener = this.configureListener(1, true, false, false, false);
        Collection deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        unit.addAttribute("sync", "false");
        this.store.enableDeploymentUnit((DeploymentUnit)unit);
        this.units.add((DeploymentUnit)unit);
        countDownListener.waitTillCompleted(4000L);
        deployed = this.deploymentService.getDeployedUnits();
        Assert.assertNotNull((Object)deployed);
        Assert.assertEquals((long)0L, (long)deployed.size());
    }
}

