/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.objects.Building;
import org.jbpm.kie.test.objects.House;
import org.jbpm.kie.test.objects.OtherPerson;
import org.jbpm.kie.test.objects.Person;
import org.jbpm.kie.test.objects.Thing;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.helper.FluentKieModuleDeploymentHelper;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.remote.Remotable;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.scanner.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredKModuleDeploymentServiceTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(FilteredKModuleDeploymentServiceTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    public void prepare(String packages) {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        ArrayList<String> processes2 = new ArrayList<String>();
        processes2.add("repo/processes/general/import.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes, processes2, packages);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        FilteredKModuleDeploymentServiceTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testDeploymentOfProcessesFromCustomerPackageDeafultKBase() {
        this.prepare("customer.repo.processes.general");
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertEquals((Object)"org.jbpm.test:test-module:1.0.0-SNAPSHOT", (Object)deployed.getDeploymentUnit().getIdentifier());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)2L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByFilter("custom", new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)2L, (long)processes.size());
        ProcessDefinition process = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)process);
    }

    @Test
    public void testDeploymentOfProcessesFromCustomerPackage() {
        this.prepare("customer.repo.processes.general");
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT", "KBase-test", "ksession-test");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertEquals((Object)"org.jbpm.test:test-module:1.0.0-SNAPSHOT:KBase-test:ksession-test", (Object)deployed.getDeploymentUnit().getIdentifier());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)2L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByFilter("custom", new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)2L, (long)processes.size());
        ProcessDefinition process = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)process);
    }

    @Test
    public void testDeploymentOfProcessesFromOrderPackage() {
        this.prepare("order.repo.processes.general");
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT", "KBase-test", "ksession-test");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertEquals((Object)"org.jbpm.test:test-module:1.0.0-SNAPSHOT:KBase-test:ksession-test", (Object)deployed.getDeploymentUnit().getIdentifier());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        ProcessDefinition process = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentUnit.getIdentifier(), "Import");
        Assert.assertNotNull((Object)process);
    }

    @Test
    public void testDeploymentOfProcessesWildcardPackage() {
        this.prepare("customer.*");
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT", "KBase-test", "ksession-test");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertEquals((Object)"org.jbpm.test:test-module:1.0.0-SNAPSHOT:KBase-test:ksession-test", (Object)deployed.getDeploymentUnit().getIdentifier());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)2L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByFilter("custom", new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)2L, (long)processes.size());
        ProcessDefinition process = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)process);
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, List<String> resources, List<String> resources2, String packages) {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, packages);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        for (String resource : resources) {
            kfs.write("src/main/resources/customer/" + resource, ResourceFactory.newClassPathResource((String)resource));
        }
        for (String resource : resources2) {
            kfs.write("src/main/resources/order/" + resource, ResourceFactory.newClassPathResource((String)resource));
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        if (!kieBuilder.buildAll().getResults().getMessages().isEmpty()) {
            for (Message message : kieBuilder.buildAll().getResults().getMessages()) {
                logger.error("Error Message: ({}) {}", (Object)message.getPath(), (Object)message.getText());
            }
            throw new RuntimeException("There are errors builing the package, please check your knowledge assets!");
        }
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks, String packages) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase-test").setDefault(true).addPackage(packages).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        kieBaseModel1.newKieSessionModel("ksession-test").setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime")).newWorkItemHandlerModel("Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    private void verifyDeployedUnitContainsCorrectClasses(DeploymentUnit deploymentUnit) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        DeploymentDescriptor descriptor = ((KModuleDeploymentUnit)deployedUnit.getDeploymentUnit()).getDeploymentDescriptor();
        boolean limitClasses = descriptor.getLimitSerializationClasses();
        boolean unAnnotatedClassesFound = false;
        for (Class depdClass : deployedUnit.getDeployedClasses()) {
            Annotation[] declAnnos = depdClass.getDeclaredAnnotations();
            boolean xmlOrRemotAnnoFound = false;
            for (Annotation depdClassAnno : declAnnos) {
                Class<? extends Annotation> annoType = depdClassAnno.annotationType();
                if (!XmlRootElement.class.equals(annoType) && !Remotable.class.equals(annoType)) continue;
                xmlOrRemotAnnoFound = true;
                break;
            }
            Assert.assertTrue((String)("Expected to find annotations on " + depdClass.getSimpleName()), (xmlOrRemotAnnoFound && limitClasses || !limitClasses ? 1 : 0) != 0);
            if (xmlOrRemotAnnoFound) continue;
            unAnnotatedClassesFound = true;
        }
        Assert.assertTrue((String)("Expected to find unannotated classes in " + deployedUnit.getDeploymentUnit().getIdentifier()), (limitClasses || !limitClasses && unAnnotatedClassesFound ? 1 : 0) != 0);
        if (limitClasses) {
            try {
                JAXBContext.newInstance((Class[])deployedUnit.getDeployedClasses().toArray(new Class[0]));
            }
            catch (JAXBException e) {
                e.printStackTrace();
                Assert.fail((String)("JAXBContext creation with deployed unit classes failed: " + e.getMessage()));
            }
        }
    }

    @Test
    public void testSerializationClassesLimitedInDeploymentItself() {
        String groupId = "org.test";
        String artifactId = "jbpm-kie-services-filter-test";
        String version = "1.0.0-SNAPSHOT";
        FluentKieModuleDeploymentHelper.newFluentInstance().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).addClass(new Class[]{Building.class, House.class, Person.class, OtherPerson.class, Thing.class}).createKieJarAndDeployToMaven();
        KModuleDeploymentUnit limitDeploymentUnit = new KModuleDeploymentUnit(groupId, artifactId, version);
        FluentKieModuleDeploymentHelper.newFluentInstance().setGroupId(groupId).setArtifactId(artifactId + "-all").setVersion(version).addClass(new Class[]{Building.class, House.class, Person.class, OtherPerson.class, Thing.class}).createKieJarAndDeployToMaven();
        KModuleDeploymentUnit allDeploymentUnit = new KModuleDeploymentUnit(groupId, artifactId + "-all", version);
        this.configureServices();
        DeploymentDescriptor depDesc = new DeploymentDescriptorImpl().getBuilder().setLimitSerializationClasses(Boolean.valueOf(true)).get();
        limitDeploymentUnit.setDeploymentDescriptor(depDesc);
        this.deploymentService.deploy((DeploymentUnit)limitDeploymentUnit);
        this.verifyDeployedUnitContainsCorrectClasses((DeploymentUnit)limitDeploymentUnit);
        depDesc = new DeploymentDescriptorImpl().getBuilder().setLimitSerializationClasses(Boolean.valueOf(false)).get();
        allDeploymentUnit.setDeploymentDescriptor(depDesc);
        this.deploymentService.deploy((DeploymentUnit)allDeploymentUnit);
        this.verifyDeployedUnitContainsCorrectClasses((DeploymentUnit)allDeploymentUnit);
    }

    @Test
    public void testSerializationClassesLimitedInDeploymentDescriptor() {
        String groupId = "org.test";
        String artifactId = "jbpm-kie-services-filter-test-desc";
        String version = "1.0.0-SNAPSHOT";
        FluentKieModuleDeploymentHelper.newFluentInstance().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).createKieJarAndDeployToMaven();
        this.configureServices();
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit(groupId, artifactId, version);
        DeploymentDescriptor depDesc = new DeploymentDescriptorImpl().getBuilder().setLimitSerializationClasses(Boolean.valueOf(true)).addClass(Building.class.getName()).addClass(House.class.getName()).addClass(Person.class.getName()).addClass(OtherPerson.class.getName()).addClass(Thing.class.getName()).get();
        deploymentUnit.setDeploymentDescriptor(depDesc);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        this.verifyDeployedUnitContainsCorrectClasses((DeploymentUnit)deploymentUnit);
    }

    @Test
    public void testSerializationClassesLimitedInDeploymentDependencies() {
        String groupId = "org.test";
        String childArtifactId = "jbpm-kie-services-filter-test-dep";
        String parentArtifactId = "jbpm-kie-services-filter-test-parent";
        String version = "1.0.0-SNAPSHOT";
        FluentKieModuleDeploymentHelper.newFluentInstance().setGroupId(groupId).setArtifactId(childArtifactId).setVersion(version).addClass(new Class[]{Building.class, House.class, Person.class, OtherPerson.class, Thing.class}).createKieJarAndDeployToMaven();
        FluentKieModuleDeploymentHelper.newFluentInstance().setGroupId(groupId).setArtifactId(parentArtifactId).setVersion(version).addDependencies(new String[]{groupId + ":" + childArtifactId + ":" + version}).createKieJarAndDeployToMaven();
        this.configureServices();
        KModuleDeploymentUnit childDeploymentUnit = new KModuleDeploymentUnit(groupId, childArtifactId, version);
        DeploymentDescriptor depDesc = new DeploymentDescriptorImpl().getBuilder().setLimitSerializationClasses(Boolean.valueOf(false)).get();
        childDeploymentUnit.setDeploymentDescriptor(depDesc);
        this.deploymentService.deploy((DeploymentUnit)childDeploymentUnit);
        KModuleDeploymentUnit parentDeploymentUnit = new KModuleDeploymentUnit(groupId, parentArtifactId, version);
        DeploymentDescriptor parentDepDesc = new DeploymentDescriptorImpl().getBuilder().setLimitSerializationClasses(Boolean.valueOf(true)).get();
        parentDeploymentUnit.setDeploymentDescriptor(parentDepDesc);
        this.deploymentService.deploy((DeploymentUnit)parentDeploymentUnit);
        this.verifyDeployedUnitContainsCorrectClasses((DeploymentUnit)parentDeploymentUnit);
    }
}

