/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.scanner.MavenRepository;

public class KModuleWithDependenciesDeploymentServiceTest
extends AbstractKieServicesBaseTest {
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private static final String ARTIFACT_ID = "jbpm-module";
    private static final String GROUP_ID = "org.jbpm.test";
    private static final String VERSION = "1.0.0";
    private static final String DATA_ARTIFACT_ID = "custom-data";
    private static final String DATA_GROUP_ID = "org.jbpm.test.data";
    private static final String DATA_VERSION = "1.0.0";

    @Before
    public void prepare() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, "1.0.0");
        File kjar = new File("src/test/resources/kjar-with-deps/jbpm-module.jar");
        File pom = new File("src/test/resources/kjar-with-deps/pom.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kjar, pom);
        ReleaseId dataReleaseId = ks.newReleaseId(DATA_GROUP_ID, DATA_ARTIFACT_ID, "1.0.0");
        File datajar = new File("src/test/resources/kjar-with-deps/custom-data.jar");
        File datapom = new File("src/test/resources/kjar-with-deps/data-pom.xml");
        repository.installArtifact(dataReleaseId, datajar, datapom);
    }

    @After
    public void cleanup() {
        KModuleWithDependenciesDeploymentServiceTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testDeploymentOfProcesses() throws Exception {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, "1.0.0", "defaultKieBase", "defaultKieSession");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertEquals((Object)"org.jbpm.test:jbpm-module:1.0.0:defaultKieBase:defaultKieSession", (Object)deployed.getDeploymentUnit().getIdentifier());
        Assert.assertTrue((boolean)(deployed instanceof DeployedUnitImpl));
        Assert.assertEquals((long)2L, (long)((DeployedUnitImpl)deployed).getDeployedClasses().size());
        ArrayList<String> classnames = new ArrayList<String>();
        for (Class clazz : ((DeployedUnitImpl)deployed).getDeployedClasses()) {
            classnames.add(clazz.getName());
        }
        Assert.assertTrue((boolean)classnames.contains("org.jbpm.data.rest.CustomDataObject"));
        Assert.assertTrue((boolean)classnames.contains("org.jbpm.test.Person"));
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        Class<?> clazz = Class.forName("org.jbpm.test.Person", true, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        Object instance = clazz.newInstance();
        HashMap params = new HashMap();
        params.put("person", instance);
        ProcessInstance processInstance = engine.getKieSession().startProcess("testkjar.src.main.resources.process", params);
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        List tasks = engine.getTaskService().getTasksOwned("salaboy", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        Map content = ((InternalTaskService)engine.getTaskService()).getTaskContent(taskId);
        Assert.assertTrue((boolean)content.containsKey("personIn"));
        Object person = content.get("personIn");
        Assert.assertEquals((Object)clazz.getName(), (Object)person.getClass().getName());
        engine.getTaskService().start(taskId, "salaboy");
        HashMap data = new HashMap();
        data.put("personOut", instance);
        engine.getTaskService().complete(taskId, "salaboy", data);
        processInstance = engine.getKieSession().getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }
}

