/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.scanner.MavenRepository;

public class PostDeploymentServiceTest
extends AbstractKieServicesBaseTest {
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();

    @Before
    public void prepare() {
        this.configureServices();
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/customtask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/signal.bpmn");
        processes.add("repo/processes/general/import.bpmn");
        processes.add("repo/processes/general/callactivity.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, pom);
    }

    @After
    public void cleanup() {
        PostDeploymentServiceTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                this.deploymentService.undeploy(unit);
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testDeploymentOfProcesses() {
        Assert.assertNotNull((Object)this.deploymentService);
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        this.units.add((DeploymentUnit)deploymentUnit);
        DeployedUnit deployed = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)deployed);
        Assert.assertNotNull((Object)deployed.getDeploymentUnit());
        Assert.assertNotNull((Object)deployed.getRuntimeManager());
        Assert.assertNotNull((Object)this.runtimeDataService);
        Collection processes = this.runtimeDataService.getProcesses(new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByFilter("custom", new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.size());
        processes = this.runtimeDataService.getProcessesByDeploymentId(deploymentUnit.getIdentifier(), new QueryContext());
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)5L, (long)processes.size());
        ProcessDefinition process = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentUnit.getIdentifier(), "customtask");
        Assert.assertNotNull((Object)process);
        RuntimeManager manager = this.deploymentService.getRuntimeManager(deploymentUnit.getIdentifier());
        Assert.assertNotNull((Object)manager);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)engine);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "test");
        ProcessInstance processInstance = engine.getKieSession().startProcess("customtask", params);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testDuplicatedDeployment() {
        Assert.assertNotNull((Object)this.deploymentService);
        ((KModuleDeploymentService)this.deploymentService).addListener(new DeploymentEventListener(){

            public void onUnDeploy(DeploymentEvent event) {
            }

            public void onDeploy(DeploymentEvent event) {
                throw new IllegalArgumentException("On purpose");
            }

            public void onActivate(DeploymentEvent event) {
            }

            public void onDeactivate(DeploymentEvent event) {
            }
        });
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT", "KBase-test", "ksession-test");
        try {
            this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
            this.units.add((DeploymentUnit)deploymentUnit);
            Assert.fail((String)"Deployment should fail due to post process failuer - see ThrowExceptionOnDeploymentEvent");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        DeployedUnit deployedGeneral = this.deploymentService.getDeployedUnit(deploymentUnit.getIdentifier());
        Assert.assertNull((Object)deployedGeneral);
        Assert.assertFalse((boolean)RuntimeManagerRegistry.get().isRegistered(deploymentUnit.getIdentifier()));
    }
}

