/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.query.SqlQueryDefinition;
import org.jbpm.kie.services.impl.query.mapper.ProcessInstanceQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.ProcessInstanceWithCustomVarsQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.ProcessInstanceWithVarsQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.RawListQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.TaskSummaryQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceWithCustomVarsQueryMapper;
import org.jbpm.kie.services.impl.query.mapper.UserTaskInstanceWithVarsQueryMapper;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.services.test.objects.TestQueryParamBuilderFactory;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.ProcessInstanceWithVarsDesc;
import org.jbpm.services.api.model.UserTaskInstanceWithVarsDesc;
import org.jbpm.services.api.query.NamedQueryMapper;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.jbpm.services.api.query.QueryParamBuilder;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.jbpm.services.api.query.model.QueryParam;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.scanner.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    protected String correctUser = "testUser";
    protected String wrongUser = "wrongUser";
    protected Long processInstanceId = null;
    protected KModuleDeploymentUnit deploymentUnit = null;
    protected KModuleDeploymentUnit deploymentUnitJPA = null;
    protected QueryDefinition query;
    protected String dataSourceJNDIname;

    @Before
    public void prepare() {
        this.dataSourceJNDIname = this.getDataSourceJNDI();
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/EmptyHumanTask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/BPMN2-UserTask.bpmn2");
        processes.add("repo/processes/general/SimpleHTProcess.bpmn2");
        processes.add("repo/processes/general/AdHocSubProcess.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        this.prepareJPAModule(ks, repository);
        Assert.assertNotNull((Object)this.processService);
    }

    protected void prepareJPAModule(KieServices ks, MavenRepository repository) {
        ReleaseId releaseIdJPA = ks.newReleaseId("org.jbpm.test", "persistence-test", "1.0.0");
        File kjarJPA = new File("src/test/resources/kjar-jpa/persistence-test.jar");
        File pomJPA = new File("src/test/resources/kjar-jpa/pom.xml");
        repository.installArtifact(releaseIdJPA, kjarJPA, pomJPA);
        this.deploymentUnitJPA = new KModuleDeploymentUnit("org.jbpm.test", "persistence-test", "1.0.0");
    }

    protected String getDataSourceJNDI() {
        return "jdbc/testDS1";
    }

    @After
    public void cleanup() {
        if (this.query != null) {
            try {
                this.queryService.unregisterQuery(this.query.getName());
            }
            catch (QueryNotFoundException queryNotFoundException) {
                // empty catch block
            }
        }
        if (this.processInstanceId != null) {
            try {
                this.processService.abortProcessInstance(this.processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
                Assert.assertNull((Object)pi);
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
                // empty catch block
            }
        }
        QueryServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testGetProcessInstances() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)new NamedQueryMapper("ProcessInstances"), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)1L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext("PROCESSNAME", false), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByState() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"STATUS", (Comparable[])new Comparable[]{Integer.valueOf(3)})});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"STATUS", (Comparable[])new Comparable[]{Integer.valueOf(3), Integer.valueOf(1)})});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"STATUS", (Comparable[])new Comparable[]{Integer.valueOf(3)})});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertEquals((long)3L, (long)((ProcessInstanceDesc)instances.iterator().next()).getState().intValue());
    }

    @Test
    public void testGetProcessInstancesByProcessId() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.likeTo((String)"PROCESSID", (boolean)true, (Comparable)((Object)"org.jbpm%"))});
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithVariables() {
        this.query = new SqlQueryDefinition("getAllProcessInstancesWithVariables", this.dataSourceJNDIname);
        this.query.setExpression("select pil.*, v.variableId, v.value from ProcessInstanceLog pil inner join (select vil.processInstanceId ,vil.variableId, MAX(vil.ID) maxvilid  FROM VariableInstanceLog vil GROUP BY vil.processInstanceId, vil.variableId ORDER BY vil.processInstanceId)  x ON (v.variableId = x.variableId  AND v.id = x.maxvilid )INNER JOIN VariableInstanceLog v ON (v.processInstanceId = pil.processInstanceId)");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        params.put("approval_translatedDocument", "translated content");
        params.put("approval_reviewComment", "reviewed content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        ProcessInstanceWithVarsDesc instance = (ProcessInstanceWithVarsDesc)processInstanceLogs.get(0);
        Assert.assertEquals((long)3L, (long)instance.getVariables().size());
        processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"VARIABLEID", (Comparable[])new Comparable[]{"approval_document"})});
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        instance = (ProcessInstanceWithVarsDesc)processInstanceLogs.get(0);
        Assert.assertEquals((long)1L, (long)instance.getVariables().size());
        processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"VARIABLEID", (Comparable[])new Comparable[]{"not existing"})});
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)0L, (long)processInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstances() {
        this.query = new SqlQueryDefinition("getAllTaskInstances", this.dataSourceJNDIname);
        this.query.setExpression("select ti.* from AuditTaskImpl ti ");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesWithVariables() {
        this.query = new SqlQueryDefinition("getAllTaskInputInstancesWithVariables", this.dataSourceJNDIname);
        this.query.setExpression("select ti.*, tv.name tvname, tv.value tvvalue from AuditTaskImpl ti inner join (select tv.taskId, tv.name, tv.value from TaskVariableImpl tv where tv.type = 0 ) tv on (tv.taskId = ti.taskId)");
        this.queryService.registerQuery(this.query);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        params.put("approval_translatedDocument", "translated content");
        params.put("approval_reviewComment", "reviewed content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        UserTaskInstanceWithVarsDesc instance = (UserTaskInstanceWithVarsDesc)taskInstanceLogs.get(0);
        Assert.assertEquals((long)3L, (long)instance.getVariables().size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"TVNAME", (Comparable[])new Comparable[]{"Comment"}), QueryParam.equalsTo((String)"TVVALUE", (Comparable[])new Comparable[]{"Write a Document"})});
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        instance = (UserTaskInstanceWithVarsDesc)taskInstanceLogs.get(0);
        Assert.assertEquals((long)1L, (long)instance.getVariables().size());
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithVarsQueryMapper.get(), new QueryContext(), new QueryParam[]{QueryParam.equalsTo((String)"TVNAME", (Comparable[])new Comparable[]{"Comment"}), QueryParam.equalsTo((String)"TVVALUE", (Comparable[])new Comparable[]{"Wrong Comment"})});
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesAsPotOwners() {
        this.query = new SqlQueryDefinition("getMyTaskInstances", this.dataSourceJNDIname, QueryDefinition.Target.PO_TASK);
        this.query.setExpression("select ti.*, oe.id OEID from AuditTaskImpl ti,PeopleAssignments_PotOwners po, OrganizationalEntity oe where ti.taskId = po.task_id and po.entity_id = oe.id ");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        this.identityProvider.setName("notvalid");
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("salaboy");
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        List taskSummaries = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)TaskSummaryQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskSummaries);
        Assert.assertEquals((long)1L, (long)taskSummaries.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesAsBA() {
        this.query = new SqlQueryDefinition("getBATaskInstances", this.dataSourceJNDIname, QueryDefinition.Target.BA_TASK);
        this.query.setExpression("select ti.*, oe.id OEID from AuditTaskImpl ti,PeopleAssignments_BAs bas, OrganizationalEntity oe where ti.taskId = bas.task_id and bas.entity_id = oe.id ");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approval_document", "initial content");
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)0L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("Administrator");
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.identityProvider.setName("salaboy");
        this.identityProvider.setRoles(Arrays.asList("Administrators"));
        taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetTaskInstancesWithCustomVariables() throws Exception {
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnitJPA);
        this.units.add((DeploymentUnit)this.deploymentUnitJPA);
        this.query = new SqlQueryDefinition("getAllTaskInstancesWithCustomVariables", this.dataSourceJNDIname);
        this.query.setExpression("select ti.*,  c.firstname, c.lastname, c.age, c.customerId from AuditTaskImpl ti inner join (select mv.map_var_id, mv.taskid from MappedVariable mv) mv on (mv.taskid = ti.taskId) inner join Customer c on (c.id = mv.map_var_id)");
        this.queryService.registerQuery(this.query);
        RuntimeManager manager = this.deploymentService.getRuntimeManager(this.deploymentUnitJPA.getIdentifier());
        Assert.assertNotNull((Object)manager);
        Class<?> clazz = Class.forName("org.jbpm.test.Customer", true, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        Object cinstance = clazz.newInstance();
        this.setFieldValue(cinstance, "firstName", "john");
        this.setFieldValue(cinstance, "lastName", "doe");
        this.setFieldValue(cinstance, "age", new Integer(45));
        this.setFieldValue(cinstance, "customerId", new Long(1234L));
        HashMap params = new HashMap();
        params.put("customer", cinstance);
        this.processInstanceId = this.processService.startProcess(this.deploymentUnitJPA.getIdentifier(), "persistence-test.customer-evaluation", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("FIRSTNAME", "string");
        variableMap.put("LASTNAME", "string");
        variableMap.put("AGE", "integer");
        variableMap.put("CUSTOMERID", "long");
        List taskInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)UserTaskInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)taskInstanceLogs);
        Assert.assertEquals((long)1L, (long)taskInstanceLogs.size());
        UserTaskInstanceWithVarsDesc instance = (UserTaskInstanceWithVarsDesc)taskInstanceLogs.get(0);
        Assert.assertEquals((long)4L, (long)instance.getVariables().size());
        Assert.assertTrue((boolean)instance.getVariables().containsKey("FIRSTNAME"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("LASTNAME"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("AGE"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("CUSTOMERID"));
        Assert.assertEquals((Object)"john", instance.getVariables().get("FIRSTNAME"));
        Assert.assertEquals((Object)"doe", instance.getVariables().get("LASTNAME"));
        Assert.assertEquals((Object)45, instance.getVariables().get("AGE"));
        Assert.assertEquals((Object)1234L, instance.getVariables().get("CUSTOMERID"));
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithQueryParamBuilder() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        Collection instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        TestQueryParamBuilderFactory qbFactory = new TestQueryParamBuilderFactory();
        Assert.assertTrue((boolean)qbFactory.accept("test"));
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("min", this.processInstanceId);
        parameters.put("max", this.processInstanceId + 2L);
        QueryParamBuilder paramBuilder = qbFactory.newInstance(parameters);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), paramBuilder);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        parameters = new HashMap();
        parameters.put("min", this.processInstanceId + 2L);
        parameters.put("max", 0L);
        paramBuilder = qbFactory.newInstance(parameters);
        instances = (Collection)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceQueryMapper.get(), new QueryContext(), paramBuilder);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithCustomVariables() throws Exception {
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnitJPA);
        this.units.add((DeploymentUnit)this.deploymentUnitJPA);
        this.query = new SqlQueryDefinition("getAllProcessInstancesWithCustomVariables", this.dataSourceJNDIname);
        this.query.setExpression("select pi.*,  c.firstname, c.lastname, c.age, c.customerId from ProcessInstanceLog pi inner join (select mv.map_var_id, mv.processInstanceId from MappedVariable mv) mv on (mv.processInstanceId = pi.processinstanceId) inner join Customer c on (c.id = mv.map_var_id)");
        this.queryService.registerQuery(this.query);
        RuntimeManager manager = this.deploymentService.getRuntimeManager(this.deploymentUnitJPA.getIdentifier());
        Assert.assertNotNull((Object)manager);
        Class<?> clazz = Class.forName("org.jbpm.test.Customer", true, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        Object cinstance = clazz.newInstance();
        this.setFieldValue(cinstance, "firstName", "john");
        this.setFieldValue(cinstance, "lastName", "doe");
        this.setFieldValue(cinstance, "age", new Integer(45));
        this.setFieldValue(cinstance, "customerId", new Long(1234L));
        HashMap params = new HashMap();
        params.put("customer", cinstance);
        this.processInstanceId = this.processService.startProcess(this.deploymentUnitJPA.getIdentifier(), "persistence-test.customer-evaluation", params);
        Assert.assertNotNull((Object)this.processInstanceId);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("FIRSTNAME", "string");
        variableMap.put("LASTNAME", "string");
        variableMap.put("AGE", "integer");
        variableMap.put("CUSTOMERID", "long");
        List processInstanceLogs = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)ProcessInstanceWithCustomVarsQueryMapper.get(variableMap), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)processInstanceLogs);
        Assert.assertEquals((long)1L, (long)processInstanceLogs.size());
        ProcessInstanceWithVarsDesc instance = (ProcessInstanceWithVarsDesc)processInstanceLogs.get(0);
        Assert.assertEquals((long)4L, (long)instance.getVariables().size());
        Assert.assertTrue((boolean)instance.getVariables().containsKey("FIRSTNAME"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("LASTNAME"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("AGE"));
        Assert.assertTrue((boolean)instance.getVariables().containsKey("CUSTOMERID"));
        Assert.assertEquals((Object)"john", instance.getVariables().get("FIRSTNAME"));
        Assert.assertEquals((Object)"doe", instance.getVariables().get("LASTNAME"));
        Assert.assertEquals((Object)45, instance.getVariables().get("AGE"));
        Assert.assertEquals((Object)1234L, instance.getVariables().get("CUSTOMERID"));
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    @Test
    public void testGetProcessInstancesWithRawMapper() {
        this.query = new SqlQueryDefinition("getAllProcessInstances", this.dataSourceJNDIname);
        this.query.setExpression("select * from processinstancelog");
        this.queryService.registerQuery(this.query);
        List queries = this.queryService.getQueries(new QueryContext());
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        QueryDefinition registeredQuery = (QueryDefinition)queries.get(0);
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        registeredQuery = this.queryService.getQuery(this.query.getName());
        Assert.assertNotNull((Object)registeredQuery);
        Assert.assertEquals((Object)this.query.getName(), (Object)registeredQuery.getName());
        Assert.assertEquals((Object)this.query.getSource(), (Object)registeredQuery.getSource());
        Assert.assertEquals((Object)this.query.getExpression(), (Object)registeredQuery.getExpression());
        Assert.assertEquals((Object)this.query.getTarget(), (Object)registeredQuery.getTarget());
        List instances = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        instances = (List)this.queryService.query(this.query.getName(), (QueryResultMapper)RawListQueryMapper.get(), new QueryContext(), new QueryParam[0]);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        List firstRow = (List)instances.get(0);
        Assert.assertNotNull((Object)firstRow);
        Assert.assertEquals((long)15L, (long)firstRow.size());
        this.processService.abortProcessInstance(this.processInstanceId);
        this.processInstanceId = null;
    }

    protected void setFieldValue(Object instance, String fieldName, Object value) {
        try {
            Field f = instance.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

