/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.util.ArrayList;
import java.util.ServiceLoader;
import org.jbpm.kie.services.api.DeploymentIdResolver;
import org.jbpm.runtime.manager.impl.filter.RegExRuntimeManagerIdFilter;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.runtime.manager.RuntimeManagerIdFilter;

public class RuntimeManagerIdentifierFilterTest {
    private static final ServiceLoader<RuntimeManagerIdFilter> runtimeManagerIdFilters = ServiceLoader.load(RuntimeManagerIdFilter.class);

    @Test
    public void testNumberOfFilterImplementationsFound() {
        Assert.assertNotNull(runtimeManagerIdFilters);
        ArrayList<String> collected = new ArrayList<String>();
        for (RuntimeManagerIdFilter filter : runtimeManagerIdFilters) {
            collected.add(filter.getClass().getName());
        }
        Assert.assertEquals((long)2L, (long)collected.size());
        Assert.assertTrue((boolean)collected.contains(RegExRuntimeManagerIdFilter.class.getName()));
        Assert.assertTrue((boolean)collected.contains(DeploymentIdResolver.class.getName()));
    }

    @Test
    public void testGAVFilteringLatest() {
        Assert.assertNotNull(runtimeManagerIdFilters);
        ArrayList<String> input = new ArrayList<String>();
        input.add("org.jbpm:test:2.0");
        input.add("org.jbpm:test:1.0");
        input.add("org.jbpm:another:1.0");
        ArrayList collected = new ArrayList();
        String pattern = "org.jbpm:test:latest";
        for (RuntimeManagerIdFilter filter : runtimeManagerIdFilters) {
            collected.addAll(filter.filter(pattern, input));
        }
        Assert.assertEquals((long)1L, (long)collected.size());
        Assert.assertEquals((Object)"org.jbpm:test:2.0", collected.get(0));
    }

    @Test
    public void testRegExFilteringAll() {
        Assert.assertNotNull(runtimeManagerIdFilters);
        ArrayList<String> input = new ArrayList<String>();
        input.add("org.jbpm:test:2.0");
        input.add("org.jbpm:test:1.0");
        input.add("org.jbpm:another:1.0");
        ArrayList collected = new ArrayList();
        String pattern = ".*";
        for (RuntimeManagerIdFilter filter : runtimeManagerIdFilters) {
            collected.addAll(filter.filter(pattern, input));
        }
        Assert.assertEquals((long)3L, (long)collected.size());
        Assert.assertTrue((boolean)collected.contains(input.get(0)));
        Assert.assertTrue((boolean)collected.contains(input.get(1)));
        Assert.assertTrue((boolean)collected.contains(input.get(2)));
    }

    @Test
    public void testRegExFilteringAllVersions() {
        Assert.assertNotNull(runtimeManagerIdFilters);
        ArrayList<String> input = new ArrayList<String>();
        input.add("org.jbpm:test:2.0");
        input.add("org.jbpm:test:1.0");
        input.add("org.jbpm:another:1.0");
        ArrayList collected = new ArrayList();
        String pattern = "org.jbpm:test:.*";
        for (RuntimeManagerIdFilter filter : runtimeManagerIdFilters) {
            collected.addAll(filter.filter(pattern, input));
        }
        Assert.assertEquals((long)2L, (long)collected.size());
        Assert.assertTrue((boolean)collected.contains(input.get(0)));
        Assert.assertTrue((boolean)collected.contains(input.get(1)));
    }

    @Test
    public void testRegExFilteringAllArtifactsAndVersions() {
        Assert.assertNotNull(runtimeManagerIdFilters);
        ArrayList<String> input = new ArrayList<String>();
        input.add("org.jbpm:test:2.0");
        input.add("org.jbpm:test:1.0");
        input.add("org.jbpm:another:1.0");
        ArrayList collected = new ArrayList();
        String pattern = "org.jbpm:.*";
        for (RuntimeManagerIdFilter filter : runtimeManagerIdFilters) {
            collected.addAll(filter.filter(pattern, input));
        }
        Assert.assertEquals((long)3L, (long)collected.size());
        Assert.assertTrue((boolean)collected.contains(input.get(0)));
        Assert.assertTrue((boolean)collected.contains(input.get(1)));
        Assert.assertTrue((boolean)collected.contains(input.get(2)));
    }

    @Test
    public void testRegExFilteringAllArtifactsWithGivenVersions() {
        Assert.assertNotNull(runtimeManagerIdFilters);
        ArrayList<String> input = new ArrayList<String>();
        input.add("org.jbpm:test:2.0");
        input.add("org.jbpm:test:1.0");
        input.add("org.jbpm:another:1.0");
        ArrayList collected = new ArrayList();
        String pattern = "org.jbpm:.*:1.0";
        for (RuntimeManagerIdFilter filter : runtimeManagerIdFilters) {
            collected.addAll(filter.filter(pattern, input));
        }
        Assert.assertEquals((long)2L, (long)collected.size());
        Assert.assertTrue((boolean)collected.contains(input.get(1)));
        Assert.assertTrue((boolean)collected.contains(input.get(2)));
    }
}

