/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.scanner.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxUserTaskServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private Long processInstanceId = null;
    private KModuleDeploymentUnit deploymentUnit = null;

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/tx/child-process-01.bpmn2");
        processes.add("repo/processes/tx/parent-process-01.bpmn2");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
    }

    @After
    public void cleanup() {
        if (this.processInstanceId != null) {
            try {
                this.processService.abortProcessInstance(this.processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
                Assert.assertNull((Object)pi);
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
                // empty catch block
            }
        }
        TxUserTaskServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testStartCompleteWithSignalInTransactions() throws Exception {
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "com.redhat.mprs.sim.parent-process-01");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.start(taskId, "john");
        ut.commit();
        ut.begin();
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("Result", "some document data");
        this.userTaskService.complete(taskId, "john", results);
        Long childProcessInstanceId = (Long)this.processService.getProcessInstanceVariable(this.processInstanceId, "childProcessInstanceId");
        this.processService.signalProcessInstance(childProcessInstanceId, "EVENT", null);
        ut.commit();
    }
}

