/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.StringUtils;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.test.KModuleDeploymentServiceTest;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.task.commands.GetTaskCommand;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.scanner.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskServiceImplTest
extends AbstractKieServicesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(KModuleDeploymentServiceTest.class);
    private List<DeploymentUnit> units = new ArrayList<DeploymentUnit>();
    private Long processInstanceId = null;
    private KModuleDeploymentUnit deploymentUnit = null;

    @Before
    public void prepare() {
        this.configureServices();
        logger.debug("Preparing kjar");
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("repo/processes/general/EmptyHumanTask.bpmn");
        processes.add("repo/processes/general/humanTask.bpmn");
        processes.add("repo/processes/general/NoFormNameHumanTask.bpmn");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, processes);
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, pom);
        Assert.assertNotNull((Object)this.deploymentService);
        this.deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        this.deploymentService.deploy((DeploymentUnit)this.deploymentUnit);
        this.units.add((DeploymentUnit)this.deploymentUnit);
        Assert.assertNotNull((Object)this.processService);
    }

    @After
    public void cleanup() {
        if (this.processInstanceId != null) {
            try {
                this.processService.abortProcessInstance(this.processInstanceId);
                ProcessInstance pi = this.processService.getProcessInstance(this.processInstanceId);
                Assert.assertNull((Object)pi);
            }
            catch (ProcessInstanceNotFoundException processInstanceNotFoundException) {
                // empty catch block
            }
        }
        UserTaskServiceImplTest.cleanupSingletonSessionId();
        if (this.units != null && !this.units.isEmpty()) {
            for (DeploymentUnit unit : this.units) {
                try {
                    this.deploymentService.undeploy(unit);
                }
                catch (Exception exception) {}
            }
            this.units.clear();
        }
        this.close();
    }

    @Test
    public void testActivate() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument.empty");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.activate(taskId, "Administrator");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Ready.toString(), (Object)task.getStatus());
    }

    @Test
    public void testReleaseAndClaim() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.release(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Ready.toString(), (Object)task.getStatus());
        this.userTaskService.claim(taskId, "salaboy");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
    }

    @Test
    public void testStartAndComplete() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.start(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.InProgress.toString(), (Object)task.getStatus());
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("Result", "some document data");
        this.userTaskService.complete(taskId, "salaboy", results);
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Completed.toString(), (Object)task.getStatus());
    }

    @Test
    public void testCompleteAutoProgress() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.release(taskId, "salaboy");
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("Result", "some document data");
        this.userTaskService.completeAutoProgress(taskId, "salaboy", results);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Completed.toString(), (Object)task.getStatus());
    }

    @Test
    public void testDelegate() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.delegate(taskId, "Administrator", "john");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"john", (Object)task.getActualOwner());
    }

    @Test
    public void testExit() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.exit(taskId, "Administrator");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Exited.toString(), (Object)task.getStatus());
    }

    @Test
    public void testStartAndFail() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.start(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.InProgress.toString(), (Object)task.getStatus());
        this.userTaskService.fail(taskId, "Administrator", new HashMap());
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Failed.toString(), (Object)task.getStatus());
    }

    @Test
    public void testStartAndForward() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.start(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.InProgress.toString(), (Object)task.getStatus());
        this.userTaskService.forward(taskId, "salaboy", "john");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Ready.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"", (Object)task.getActualOwner());
    }

    @Test
    public void testSuspendAndResume() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.suspend(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Suspended.toString(), (Object)task.getStatus());
        this.userTaskService.resume(taskId, "salaboy");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
    }

    @Test
    public void testStartAndStop() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.start(taskId, "salaboy");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.InProgress.toString(), (Object)task.getStatus());
        this.userTaskService.stop(taskId, "salaboy");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
    }

    @Test
    public void testSkip() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        this.userTaskService.skip(taskId, "Administrator");
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Obsolete.toString(), (Object)task.getStatus());
    }

    @Test
    public void testNominate() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument.empty");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        ArrayList<Object> owners = new ArrayList<Object>();
        User user = TaskModelProvider.getFactory().newUser("john");
        owners.add(user);
        user = TaskModelProvider.getFactory().newUser("salaboy");
        owners.add(user);
        Group group = TaskModelProvider.getFactory().newGroup("HR");
        owners.add(group);
        this.userTaskService.nominate(taskId, "Administrator", owners);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Ready.toString(), (Object)task.getStatus());
    }

    @Test
    public void testSetPriority() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((long)9L, (long)task.getPriority().intValue());
        this.userTaskService.setPriority(taskId, 8);
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((long)8L, (long)task.getPriority().intValue());
    }

    @Test
    public void testSetExpirationDate() throws Exception {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Date origDueDate = task.getDueDate();
        Assert.assertNull((Object)origDueDate);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.userTaskService.setExpirationDate(taskId, sdf.parse("2013-12-31"));
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"2013-12-31", (Object)sdf.format(task.getDueDate()));
    }

    @Test
    public void testSetSkippable() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        Task taskInstance = this.userTaskService.getTask(taskId);
        Assert.assertNotNull((Object)taskInstance);
        Assert.assertEquals((Object)Status.Reserved, (Object)taskInstance.getTaskData().getStatus());
        Assert.assertTrue((boolean)taskInstance.getTaskData().isSkipable());
        this.userTaskService.setSkipable(taskId, false);
        taskInstance = this.userTaskService.getTask(taskId);
        Assert.assertNotNull((Object)taskInstance);
        Assert.assertEquals((Object)Status.Reserved, (Object)taskInstance.getTaskData().getStatus());
        Assert.assertFalse((boolean)taskInstance.getTaskData().isSkipable());
    }

    @Test
    public void testSetName() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"Write a Document", (Object)task.getName());
        this.userTaskService.setName(taskId, "updated");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"updated", (Object)task.getName());
    }

    @Test
    public void testSetDescription() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"Write a Document", (Object)task.getDescription());
        this.userTaskService.setDescription(taskId, "updated");
        task = this.runtimeDataService.getTaskById(taskId);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)Status.Reserved.toString(), (Object)task.getStatus());
        Assert.assertEquals((Object)"updated", (Object)task.getDescription());
    }

    @Test
    public void testContentRelatedOperations() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        Map input = this.userTaskService.getTaskInputContentByTaskId(taskId);
        Assert.assertNotNull((Object)input);
        Assert.assertEquals((long)6L, (long)input.size());
        Assert.assertTrue((boolean)input.containsKey("ActorId"));
        Assert.assertTrue((boolean)input.containsKey("Comment"));
        Assert.assertTrue((boolean)input.containsKey("TaskName"));
        Assert.assertTrue((boolean)input.containsKey("NodeName"));
        Assert.assertTrue((boolean)input.containsKey("Priority"));
        Assert.assertTrue((boolean)input.containsKey("Skippable"));
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("Content", "testing save");
        values.put("Author", "john");
        Long contentId = this.userTaskService.saveContent(taskId, values);
        Assert.assertNotNull((Object)contentId);
        Map output = this.userTaskService.getTaskOutputContentByTaskId(taskId);
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((long)2L, (long)output.size());
        Assert.assertTrue((boolean)output.containsKey("Content"));
        Assert.assertTrue((boolean)output.containsKey("Author"));
        this.userTaskService.deleteContent(taskId, contentId);
        output = this.userTaskService.getTaskOutputContentByTaskId(taskId);
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((long)0L, (long)output.size());
    }

    @Test
    public void testCommentOperations() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        List comments = this.userTaskService.getCommentsByTaskId(taskId);
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)0L, (long)comments.size());
        Long commentId = this.userTaskService.addComment(taskId, "Simple comment", "john", new Date());
        Assert.assertNotNull((Object)commentId);
        Long commentId2 = this.userTaskService.addComment(taskId, "Another comment", "john", new Date());
        Assert.assertNotNull((Object)commentId2);
        comments = this.userTaskService.getCommentsByTaskId(taskId);
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)2L, (long)comments.size());
        Comment cm = this.userTaskService.getCommentById(taskId, commentId2);
        Assert.assertNotNull((Object)cm);
        Assert.assertEquals((Object)"john", (Object)cm.getAddedBy().getId());
        Assert.assertEquals((Object)"Another comment", (Object)cm.getText());
        this.userTaskService.deleteComment(taskId, commentId2);
        comments = this.userTaskService.getCommentsByTaskId(taskId);
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)1L, (long)comments.size());
    }

    @Test
    public void testAttachmentOperations() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        List attachments = this.userTaskService.getAttachmentsByTaskId(taskId);
        Assert.assertNotNull((Object)attachments);
        Assert.assertEquals((long)0L, (long)attachments.size());
        Long attId = this.userTaskService.addAttachment(taskId, "john", "my attachment", (Object)"String attachment");
        Assert.assertNotNull((Object)attId);
        attachments = this.userTaskService.getAttachmentsByTaskId(taskId);
        Assert.assertNotNull((Object)attachments);
        Assert.assertEquals((long)1L, (long)attachments.size());
        String content = (String)this.userTaskService.getAttachmentContentById(taskId, attId);
        Assert.assertNotNull((Object)content);
        Assert.assertEquals((Object)"String attachment", (Object)content);
        Attachment attachment = this.userTaskService.getAttachmentById(taskId, attId);
        Assert.assertNotNull((Object)attachment);
        Assert.assertEquals((Object)"john", (Object)attachment.getAttachedBy().getId());
        Assert.assertEquals((Object)"my attachment", (Object)attachment.getName());
        Assert.assertNotNull((Object)attachment.getAttachmentContentId());
        Assert.assertEquals((Object)"java.lang.String", (Object)attachment.getContentType());
        this.userTaskService.deleteAttachment(taskId, attId);
        attachments = this.userTaskService.getAttachmentsByTaskId(taskId);
        Assert.assertNotNull((Object)attachments);
        Assert.assertEquals((long)0L, (long)attachments.size());
    }

    @Test
    public void testExecute() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        Task task = (Task)this.userTaskService.execute(this.deploymentUnit.getIdentifier(), (Command)new GetTaskCommand(taskId.longValue()));
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        Assert.assertEquals((Object)"Write a Document", (Object)task.getName());
    }

    @Test
    public void testGetTask() {
        this.processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "org.jbpm.writedocument.noform");
        Assert.assertNotNull((Object)this.processInstanceId);
        List taskIds = this.runtimeDataService.getTasksByProcessInstanceId(this.processInstanceId);
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId = (Long)taskIds.get(0);
        Task taskInstance = this.userTaskService.getTask(taskId);
        Assert.assertNotNull((Object)taskInstance);
        Assert.assertEquals((Object)Status.Reserved, (Object)taskInstance.getTaskData().getStatus());
        Assert.assertEquals((Object)"Write a Document", (Object)taskInstance.getName());
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)((InternalTask)taskInstance).getFormName()));
    }
}

