/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.test.objects;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoundDownDeploymentListener
implements DeploymentEventListener {
    private static Logger logger = LoggerFactory.getLogger(CoundDownDeploymentListener.class);
    private CountDownLatch latch;
    private boolean deploy;
    private boolean undeploy;
    private boolean activate;
    private boolean deactivate;

    public CoundDownDeploymentListener() {
        this.latch = new CountDownLatch(0);
    }

    public CoundDownDeploymentListener(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    public void onDeploy(DeploymentEvent event) {
        if (this.deploy) {
            this.latch.countDown();
        }
    }

    public void onUnDeploy(DeploymentEvent event) {
        if (this.undeploy) {
            this.latch.countDown();
        }
    }

    public void onActivate(DeploymentEvent event) {
        if (this.activate) {
            this.latch.countDown();
        }
    }

    public void onDeactivate(DeploymentEvent event) {
        if (this.deactivate) {
            this.latch.countDown();
        }
    }

    public void waitTillCompleted() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            logger.debug("Interrputed thread while waiting for all triggers notification/reassignment");
        }
    }

    public void waitTillCompleted(long timeOut) {
        try {
            this.latch.await(timeOut, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.debug("Interrputed thread while waiting for all triggers notification/reassignment");
        }
    }

    public void reset(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    public boolean isDeploy() {
        return this.deploy;
    }

    public void setDeploy(boolean deploy) {
        this.deploy = deploy;
    }

    public boolean isUndeploy() {
        return this.undeploy;
    }

    public void setUndeploy(boolean undeploy) {
        this.undeploy = undeploy;
    }

    public boolean isActivate() {
        return this.activate;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    public boolean isDeactivate() {
        return this.deactivate;
    }

    public void setDeactivate(boolean deactivate) {
        this.deactivate = deactivate;
    }
}

